//
// simple example 10: 
// alternating sums
//


#include  "../src/include/hfloat.h"


int main()
{
    // precision in LIMBs, use o power of two <= 1024:
    hfloat::default_prec(256);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);


    hfloat s;
    cout << " decimal precision=" << prec_convert(s.prec(),10) << endl;

    // ------ compute pi:
    sumalt(gregory_term, s);  // compute pi as arctan(1)
    s *= 4;
    cout << "pi=" << s << endl;

    // ------ check pi:
    hfloat p = hfloat();
    p = constant_pi(p.prec()); //pi_4th_order(p);
    s -= p;
    print("small=",s,3);
    cout << endl;


    sumalt(catalan_term, s);  // compute catalan=0.91596...
    cout << "\n catalan= " << s << endl;

    sumalt(log2_term, s);  // compute log(2) = 0.69314...
    cout << "\n log(2)=" << s << endl;

    cout << endl;

    return 0;
}
//---------------
