//
// simple example 11: 
// ackermann function
//

#include  "../src/include/hfloat.h"


hfloat
op(int n, const hfloat &a, const hfloat &b)
{
//    cout << " op(" << n << ", " << a << ", " << b << ")";
    hfloat r;
    r = 1;
    if ( n==0 )  // op_0 = add
    {
        r = a;  r += b;
    }
    else if ( n==1 ) // op_1 = multiply
    {
        r = a;  r *= b;
    }
    else
    {
        hfloat ta, tb;  ta = a;  tb = b;
        while ( 1 )
        {
//            cout << "      n=" << n << "  ta=" << ta << "  tb=" << tb << endl;
            if ( tb.odd() )
            {
                r = op(n-1,ta,r);
            }
            
            tb /= 2;
            if ( (long)1>tb )  break;

            ta = op(n-1,ta,ta);
        }
//        cerr << " els  r=" << r << endl;
    }
//    cout << "=" << r << endl;
    return r;
}
//--------------


int main()
{
    // precision in LIMBs, use o power of two:
    hfloat::default_prec(64);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);

    hfloat a,b, ab, ba;
    long minab = 1;
    long maxab = 4;
    double ad,bd; //, abd, bad;

    for (int n=0; n<=4; n++)
    {
        cout << " --- n=" << n << " --- ";
        switch ( n )
        {
        case 0:  cout << "add";  break;
        case 1:  cout << "mul";  break;
        case 2:  cout << "pow";  break;
        case 3:  cout << "tower";  break;
        case 4:  cout << "wow";  break;
        default:  cout << "!!!";  break;
        }
        cout << endl;
        
        for (a=minab; a<=maxab; ++a)
        {
            cout << " -- " << endl;
            for (b=minab; b<=maxab; ++b)
            {
                hfloat2d(a,ad);  cout << "a=" << ad;
                hfloat2d(b,bd);  cout << "  b=" << bd;

                ab = op(n,a,b);
                save_nn(cout,"  ab==",ab,7);                

                ba = op(n,b,a);            
                save_nn(cout,"  ba==",ba,7);

                cout << endl;            
            }
        }
    }
}
//--------------
