//
// simple example 3: 
// golden ratio & fibonacci numbers
//


#include  "../src/include/hfloat.h"
#include  "../src/include/hfverbosity.h"
#include  "../src/fxt/mult/fxtmult.h"


int main()
{
    hfverbosity::tell_all();
    
    const ulong ppr = 0;  // how many LIMBs to print, 0 ==> full prec

    // precision in LIMBs, use o power of two:
    ulong prec = 512;
    hfloat::default_prec(prec);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);

    hfloat a,b,c,d;

    // ----- golden ratio:
    isqrt(5,b);  // b=1/sqrt(5)
    a = b;
    a *= 5;      // a=sqrt(5)
    a += 1;
    a /= 2;      // a=(sqrt(5)+1)/2
    print("\n golden ratio= \n",a,ppr);

    // check precision:   
    sqr(a,d);  d -= a;  d -= 1;  // d = a*a-a-1
    print(" 0.0 = approx = \n",d,ppr);

    // ----- fibonacci_k = round(golden^k/sqrt(5)):
    long k = 9700;
    pow(a,k,d);  // d=golden^k
    mul(d,b,c);  // c=golden^k/sqrt(5)
    //    print("\n  golden^k/sqrt(5)= \n",c,ppr);

    floor(c,c);
    if( k&1 )  c += 1;

    cout<<"\n fibonacci_"<<k;
    print(" = \n",c,ppr);


    // ----- lukas_k = round(golden^k):
    floor(d,d);
    if( !(k&1) )  d += 1;

    cout<<"\n lukas_"<<k;
    print(" = \n",d,ppr);

    cout << endl;
    fxtmult::print_statistics(prec);

    return 0;
}
//---------------



/*
// list of fibonacci numbers:
for(long i=0; i<20; ++i)  cout<<"\n fib_"<<i<<" = "<<fib(i);
cout<<endl;

long fib(long k)
{
    if( k==0 )  return 0;  // =2 for lukas numbers
    if( k==1 )  return 1;

    return fib(k-1) + fib(k-2);
}

 fib_0 = 0
 fib_1 = 1
 fib_2 = 1
 fib_3 = 2
 fib_4 = 3
 fib_5 = 5
 fib_6 = 8
 fib_7 = 13
 fib_8 = 21
 fib_9 = 34
 fib_10 = 55
 fib_11 = 89
 fib_12 = 144
 fib_13 = 233
 fib_14 = 377
 fib_15 = 610
 fib_16 = 987
 fib_17 = 1597
 fib_18 = 2584
 fib_19 = 4181

 luk_0 = 2
 luk_1 = 1
 luk_2 = 3
 luk_3 = 4
 luk_4 = 7
 luk_5 = 11
 luk_6 = 18
 luk_7 = 29
 luk_8 = 47
 luk_9 = 76
 luk_10 = 123
 luk_11 = 199
 luk_12 = 322
 luk_13 = 521
 luk_14 = 843
 luk_15 = 1364
 luk_16 = 2207
 luk_17 = 3571
 luk_18 = 5778
 luk_19 = 9349

*/
