//
// simple example 9: 
// some constants printed in the book
//

#include <iostream.h>
#include <assert.h>

#include  "../src/include/hfloat.h"
#include  "../src/include/hfverbosity.h"


void misc(ulong p);

int main()
{
    hfverbosity::hush_all();

    hfloat::default_prec(128);

    hfloat::radix(10000);
    misc(25+1);

    hfloat::radix(65536);
    misc(25+1);

    return 0;
}
//---------------

static void
check(const hfloat &a, const hfloat &b)
{
    ulong d;
    cmp(a, b, d);
    d = a.prec() - d;
    cout << " the last " << d
         << " LIMBs (of total " << a.prec()
         << ") are incorrect " << endl;
    assert( d<15 );
}
//---------------

void
misc(ulong p)
//
// print with precision p
//
{
    hfloat t;
    hfloat pi;
    hfloat e;
    hfloat i(64);

    cout << "\n pi =";  cout.flush();
    pi_4th_order(pi);
    print( "\n", pi, p);


    cout << "\n pi^2 =";  cout.flush();
    sqr(pi,t);
    print("\n", t, p);


    cout << "\n pi^3 =";  cout.flush();
    pow(pi,3,t);
    print("\n", t, p);


    cout << "\n pi^4 =";  cout.flush();
    pow(pi,4,t);
    print("\n", t, p);


    cout << "\n pi^(1/2) =";  cout.flush();
    sqrt(pi,t);
    print("\n", t, p);


    cout << "\n pi^(1/3) =";  cout.flush();
    cbrt(pi,t);
    print("\n", t, p);


    cout << "\n pi^(1/4) =";  cout.flush();
    root(pi,4,t);
    print("\n", t, p);

    cout << "\n e =";  cout.flush();
    e = 1;
    exp(e,e);
    print( "\n", e, p);

    
    cout << "\n e^pi =";  cout.flush();
    exp(pi,t);
    print("\n", t, p);
    // check:
    log(t,t);    // pi
    check(pi,t);


    cout << "\n pi^e =";  cout.flush();
    pow(pi,e,t);
    print("\n", t, p);
    // check:
    log(t,pi,t); // e
    check(e,t);

    cout << "\n e^(pi/4) =";  cout.flush();
    exp(pi/4,t);
    print("\n", t, p);


    cout << "\n ln(pi) =";  cout.flush();
    log(pi,t);
    print("\n", t, p);


    cout << "\n log_2(pi) =";  cout.flush();
    i = 2;
    log(pi,i,t);
    print("\n", t, p);


    cout << "\n log_10(pi) =";  cout.flush();
    i = 10;
    log(pi,i,t);
    print("\n", t, p);


    cout << "\n exp(sqrt(163)*pi) =";  cout.flush();
    sqrt(163,t);
    t *= pi;
    exp(t,t);
    print("\n", t, p);

    cout << "\n exp(sqrt(163)/3*pi) =";  cout.flush();
    cbrt(t,t);
    print("\n", t, p);
}
//---------------

