//
// well, ... *semi* simple example 999: 
// compute n**(n**n)
//

#include  "../src/include/hfloat.h"
#include  "../src/include/hfverbosity.h"
#include  "../src/fxt/mult/fxtmult.h"

#include <math.h>
#include <iomanip.h>
#include <stdlib.h>  // atol()
#include <assert.h>  // assert()
#include <unistd.h>  // unlink()

#define  XI(z)  \
 setw(8) << z.exp() << " [" << setw(2) << ceil(log(double(z.exp()))/log(2.0)) << "]"


int
main(int argc, char **argv)
{
    int pinq = 0;  // whether to print 'input' of mult/sqr
    int poutq = 1; // whether to print result of mult/sqr
    ulong pp = 8;  // print prec. for above

    ulong n = 7;
    if ( argc>1 )  n = atol(argv[1]);

    ulong x = 1;
    for (ulong i=0; i<n; ++i)  x *= n;

    cout << "n = " << n << endl;
    cout << " ... computing  n**(n**n) = "  << n  << " ** " << x << endl;
    cout << endl;

    hfloat::radix(1000);

    ulong prec = (ulong)ceil( prec_convert(x, hfloat::radix(), n) );
    hfloat::default_prec(prec);
    hfverbosity::tell_all();
    hfverbosity::tell_fxtmult();
    hfloat::print_info();

    hfloat a, c, t;
    a.prec(1);
    c.prec(1);
    t.prec(1);
    a = n;

    c = 1;
    int firstq = 1;
    while ( 1 )
    {
        if ( x&1 )  // odd
        {

            t.prec( a.prec() + c.prec() );
            if ( pinq )  print("\na=", a, pp);
            if ( pinq )  print("c=", c, pp);
            cout << XI(c) << ", " << XI(a) << "  -- ";

            if ( firstq ) // avoid multiplication by 1
            {
                cout << " == ";
                t = a;
                firstq = 0;
            }
            else
            {
                mul(c, a, t);
            }

            cout << " -->  " << XI(t) << endl;

            c.prec( t.exp() );
            c.copy( t );
            if ( poutq )  print("a*c==", c, pp);

            if ( x==1 )  break;
        }


        t.prec( a.prec() + a.prec() );        

        if ( pinq )  print("\na=", a, pp);

        cout << XI(a) << "                 -- ";
        sqr(a, t);
        cout << " -->  " << XI(t) << endl;

        a.prec( t.exp() );
        a.copy( t );
        if ( poutq ) print("a*a==", t, pp);

        x /= 2;
    }

    cout << "\n computation finished." << endl;
    print("n**(n**n)==\n",c,16);
    cout << endl << " prec=" << c.prec() << " LIMBs " 
         << " == " << prec_convert(c.prec(),10) << " dec.dig. " << endl;
    cout << endl;

    const char *fname = "/tmp/result.txt";
    cout << "saving result to file \"" << fname << "\" ... ";
    save(fname, c);
    cout << "done." << endl;

    hfloat::print_info();
    hfdata::print_statistics(prec);
    fxtmult::print_statistics(prec);

    return 0;
}
//---------------
