
#include "hfdatafu.h"
#include "auxtempl.h"  // null(), shift_right()

#include "jjassert.h"
#include "dtparanoia.h"



ulong
dt_int_to_mantissa(ulong i, hfdata &a)
// returns how many LIMBs were made
{
    LIMB *ad = a.dig();
    null(ad, a.prec());

    ulong k = 0;
    for (  ; i!=0; ++k)
    {
        jjassert2( (k<a.prec()), "overflow while converting from integer" );
        
        if ( k!=0 )  shift_right(ad, k+1, 1);

        const ulong  rx = hfdata::rx;
        ad[0] = i % rx;
        i     = i / rx;
    }

#ifdef  DT_PARANOIA
    jjassert( a.OK() );
#endif

   return k;
}
//=============== end =======================
