
#include "hfdata.h"
#include "auxtempl.h"  // shift_right(), ...

#include "jjassert.h"
#include "dtparanoia.h"


int
dt_mul2(hfdata &a)
//
// returns whether shift happened
//
{
#ifdef  DT_PARANOIA
    jjassert( a.OK() );
#endif

    const int rx = hfdata::rx;
    ulong cy;
    LIMB *ad = a.dig();


    if ( hfdata::rx2pw )  // radix is a power of 2
    {
        const int nine = rx-1;
	ulong t = 0;
	for (long k=a.prec()-1; k>=0; --k)
	{
	    t |= (ulong)ad[k]<<1;
	    ad[k] = t&nine;
	    t >>= (hfdata::rxbits);
	}

	cy = t; 
    }
    else  // radix _not_ a power of 2
    {
	cy = 0;
	for (long k=a.prec()-1; k>=0; --k)
	{
	    ulong t = ((ulong)ad[k]<<1)+cy;
    
	    if ( t>=(ulong)rx )
	    {
		cy = 1;
		ad[k] = t-rx;
	    }
	    else
	    {
		cy = 0;
		ad[k] = t;
	    } 
	}
    }

    int ret;
    if ( cy!=0 )
    {
        shift_right(ad, a.prec(), 1);
        ad[0] = 1;
        ret = 1;
    }
    else  ret = 0;

#ifdef  DT_PARANOIA
    jjassert( a.OK() );
#endif

    return ret;
}
//===================== end =========================



int
dt_div2(hfdata &a)
//
// returns whether shift happened
//
{
#ifdef  DT_PARANOIA
    jjassert( a.OK() );
#endif

    const uint rx = hfdata::rx;
    ulong cy;
    LIMB *ad = a.dig();


    if ( hfdata::rx2pw )  // radix is a power of 2
    {
	ulong t = 0;
	for (ulong k=0; k<a.prec(); ++k)
	{
	    t |= ad[k];
	    cy = t&1;
	    ad[k] = t>>1;
	    t = cy << (hfdata::rxbits);
	}
    }
    else  // radix _not_ a power of 2
    {
	cy = 0;
	for (ulong k=0; k<a.prec(); ++k)
	{
	    ulong t = ad[k];
    
	    if ( cy!=0 )  t += rx;
	    cy = t&1;
            ad[k] = (LIMB)(t>>1);
	}
    }

    int ret;
    if ( ad[0]==0 )
    {
        shift_left(ad, a.prec(), 1);
        ret = 1;
    }  
    else  ret = 0;

#ifdef  DT_PARANOIA
    jjassert( a.OK() );
#endif

    return ret;
}
//===================== end ======================

