#if !defined __ARRAY_H
#define      __ARRAY_H

#include "fxttypes.h"
#include "auxtempl.h"
#include "auxbit.h"


template <typename Type>
class array
{
public:
    array(ulong _n, Type *_f=NULL);
    ~array();

    Type *get_f()  const  { return f; }

    void null()  { ::null(f,n); }
    void copy(array<Type> a)  { ::copy(a.get_f(), a.n, f,n); }
    void min_max(Type *mi, Type *ma)  const  { ::min_max(f,n, mi,ma); }
    void linear_scale(Type mi, Type ma, Type nmi, Type nma)  { ::linear_scale(f,n, mi,ma,nmi,nma); }
    void linear_scale(Type nmi, Type nma)  { ::linear_scale(f,n, nmi,nma); }
    void log_scale(double xi, double xa, Type nma)  { ::log_scale(f,n, xi,xa,nma); }

    void apply_func(Type (*func)(Type)) { ::apply_func(f,n, func); }

    void shift_left(ulong r)  { ::shift_left(f,n, r); }
    void shift_right(ulong r)  { ::shift_right(f,n, r); }
    void shift(long vert, long horiz)  { ::shift(f,n, vert,horiz); }

    void reverse()  { ::reverse(f,n); }

    void rotate_left(ulong r)  { ::rotate_left(f,n, r); }
    void rotate_right(ulong r)  { ::rotate_right(f,n, r); }
    void rotate(long r)  { ::rotate(f,n, r); }

//    void zero2center()  { ::zero2center(f,n); }

    // --- data:
public:
    const ulong n;
    const ulong ldn;
private:
    Type *f;
    bool myfq;
};
//---------------------------------------------



template <typename Type>
array<Type>::array(ulong _n, Type *_f=0)
    : n(_n), ldn(ldq(_n))
{
    if ( 0!=_f )
    {
        f = _f;
        myfq = false;
    }
    else
    {
        f = new Type[n];
        myfq = true;
    }
}
//-----------------------


template <typename Type>
array<Type>::~array()
{
    if ( myfq )  delete [] f;
}
//-----------------------



template <typename Type>
void
copy(const array<Type> &src,
     array<Type> &dst,
     ulong off/*=0*/)
{
    dst.null();
    ::offset_copy(src.get_f(), src.n,
                  dst.get_f(), dst.n,
                  off);
}
//-----------------------


template <typename Type>
void copy(const array<Type> &src, array<Type> &dst, ulong off=0);


#endif  // !defined __ARRAY_H
