#if !defined __INLINE_H
#define      __INLINE_H


#include "fxttypes.h"


template <typename Type>
inline void  swap(Type &x, Type &y)
{ Type t = x;  x = y;  y = t; }

template <typename Type>
inline void  swap0(Type &x, Type &y)
// swap() for y known to be zero
{ y = x;  x = 0; }

template <typename Type>
inline Type  min(const Type &x, const Type &y)
{ return  x<y ? x : y; }

template <typename Type>
inline Type  max(const Type &x, const Type &y)
{ return  x>y ? x : y; }

template <typename Type>
inline int   sign(const Type &x)
{ return  x<0 ? -1 : (x==0?0:1); }

template <typename Type>
inline Type  abs(const Type &x)
{ return  x>=0 ? x : -x; }

template <typename Type>
inline void sort2(Type &x1, Type &x2)
{ if (x1>x2) {Type t=x1; x1=x2; x2=t;} }

template <typename Type>
inline int in_range_q(Type x, Type xmin, Type xmax)
{ return ( (x>=xmin) && (x<=xmax) ); }

template <typename Type>
inline void clip_range(Type &x, Type xmin, Type xmax)
{
    if      ( x<xmin )  { x = xmin; return; }
    else if ( x>xmax )  { x = xmax; }
}


#endif // !defined __INLINE_H
