#if !defined __MINMAX_H
#define      __MINMAX_H

#include "fxttypes.h"


template <typename Type>
Type
min(const Type *f, ulong n)
// returns minimum of array
{
    Type v = f[0];
    while ( n-- )
    {
        if ( f[n]<v )  v = f[n];
    }
    return v;
}
//-----------------------


template <typename Type>
ulong
min_idx(const Type *f, ulong n)
// returns index of minimum of array
{
    ulong idx = 0;
    Type v = f[idx];
    while ( n-- )
    {
        if ( f[n]<v )
        {
            v = f[n];
            idx = n;
        }
    }
    return  idx;
}
//-----------------------


template <typename Type>
Type
max(const Type *f, ulong n)
// returns maximum of array

{
    Type v = f[0];
    while ( n-- )
    {
        if ( f[n]>v )  v = f[n];
    }
    return v;
}
//-----------------------


template <typename Type>
ulong
max_idx(const Type *f, ulong n)
// returns index of maximum of array
{
    ulong idx = 0;
    Type v = f[idx];
    while ( n-- )
    {
        if ( f[n]>v )
        {
            v = f[n];
            idx = n;
        }
    }
    return idx;
}
//-----------------------


template <typename Type>
void
min_max(const Type *f, ulong n, Type *mi, Type *ma)
// sets *mi to minimum of array
// and  *ma to maximum of array
{
    Type i = f[0];
    Type a = f[0];
    while ( n-- )
    {
        if ( f[n]<i )  i = f[n];
        if ( f[n]>a )  a = f[n];
    }
    *mi = i;
    *ma = a;
}
//-----------------------


template <typename Type>
void
min_max_idx(const Type *f, ulong n, ulong *ii, ulong *ia)
// sets *ii to index of minimum of array
// and  *ia to index of maximum of array
{
    ulong idxi = 0, idxa =0;
    Type mi = f[idxi];
    Type ma = f[idxa];
    while ( n-- )
    {
        if ( f[n]<mi )
        {
            mi = f[n];
            idxi = n;
        }
 
        if ( f[n]>ma )
        {
            ma = f[n];
            idxa = n;
        }
    }

    *ii = idxi;
    *ia = idxa;
}
//-----------------------


template <typename Type>
void
update_min_max(const Type *f, ulong n, Type *mi, Type *ma)
// sets *mi to minimum of array_min and *mi
// and  *ma to maximum of array_max and *ma
{
    Type i,a;
    min_max(f,n,&i,&a);
    if ( *mi<i )  *mi = i;
    if ( *ma<a )  *ma = a;
}
//-----------------------


template <typename Type>
ulong
next_min5_idx(const Type *f, ulong n, ulong start=0)
// returns index of first element (index >= start+2)
// which is minimal wrt. its 2 left and 2 right neighbours
// if no such element is found, n is returned
{
    if ( n<start+5 )  return n;

    ulong i = start;
    Type a, b=f[i], c=f[i+1], d=f[i+2], e=f[i+3];
    for (  ; i+4<n; ++i)
    {
        a = b;
        b = c;
        c = d;
        d = e;
        e = f[i+4];

        if ( c<a && c<b && c<d && c<e )  return i+2;
    }

    return  n;
}
//-----------------------


template <typename Type>
ulong
next_max5_idx(const Type *f, ulong n, ulong start=0)
// returns index of first element (index >= start+2)
// which is maximal wrt. its 2 left and 2 right neighbours
// if no such element is found, n is returned
{
    if ( n<start+5 )  return n;

    ulong i = start;
    Type a, b=f[i], c=f[i+1], d=f[i+2], e=f[i+3];
    for (  ; i+4<n; ++i)
    {
        a = b;
        b = c;
        c = d;
        d = e;
        e = f[i+4];

        if ( c>a && c>b && c>d && c>e )  return i+2;
    }

    return  n;
}
//-----------------------


template <typename Type>
ulong
max_sumbox_idx(const Type *f, ulong n, ulong boxlen)
// finds box of length boxlen
// for which sum of the elements is maximal
// returns index of first element of that box
{
    if ( n<=boxlen )  return 0;

    Type bv = 0;  // box value
    for (ulong i=0; i<boxlen; ++i)  bv += f[i];  // value of box[0]
    Type   mbv = bv;  // max box value
    ulong  mbi = 0;   // max box index

    for (ulong i=1; i<=n-boxlen; ++i)
    {
        bv = bv - f[i-1] + f[i+boxlen-1];  // value of box[i]  
        if ( bv>mbv )
        {
            mbv = bv;
            mbi = i;
        }
    }

    return mbi;
}
//-----------------------

template <typename Type>
ulong
min_sumbox_idx(const Type *f, ulong n, ulong boxlen)
// finds box of length boxlen
// for which sum of the elements is minimal
// returns index of first element of that box
{
    if ( n<=boxlen )  return 0;

    Type bv = 0;  // box value
    for (ulong i=0; i<boxlen; ++i)  bv += f[i];  // value of box[0]
    Type   mbv = bv;  // max box value
    ulong  mbi = 0;   // max box index

    for (ulong i=1; i<=n-boxlen; ++i)
    {
        bv = bv - f[i-1] + f[i+boxlen-1];  // value of box[i]  
        if ( bv<mbv )
        {
            mbv = bv;
            mbi = i;
        }
    }

    return mbi;
}
//-----------------------


#endif // !defined __MINMAX_H
