
#include <math.h>
#include <assert.h>

#include "fxttypes.h"
#include "auxdouble.h"

// jjnote: semi - untested !


ulong
resample_sinc(const double *a, ulong an, double af, double *b, double bf, ulong bn)
// input: an samples with freq af
// output: bn samples with freq bf
// return: # of samples produced (<=bn)
{
    double v = af/bf;  // freq ratio
    assert( v>0 );

    ulong  n = 1+(ulong)(an/v);  // # of samples produced  ??? correct
    if ( n>bn )  n =bn;

    for (ulong j=0; j<n; j++) 
    {
	double s = j * v;
        ulong  i = (ulong)s;
        double r = s - i;

        b[j]=
	    (a[i]  *sinc(2+r)+
	     a[i+1]*sinc(1+r)+
	     a[i+2]*sinc(r)+
	     a[i+3]*sinc(1-r)+
	     a[i+4]*sinc(2-r)+
	     a[i+5]*sinc(3-r));   //*0.5;
    }

    return n;
}
//============ end =============



ulong
sample_down_linear(const double *f, ulong nf, double v, double *g, ulong ng)
//
// uses linear interpolation (if noninteger v)
// returns number of values produced
//
{
    assert( v>=1.0 );

    ulong n = ulong(nf/v);  // n values will be produced
    if ( n>ng )  n = ng;

    ulong gi,fi;
    if ( v==floor(0.5+v) )  // ----- integer value
    {
        const ulong vi = ulong(floor(0.5+v));
        for (fi=0,gi=0; gi<n; gi++,fi+=vi)  g[gi] = f[fi];
    }
    else  // ----- non integer value
    {
        double dfi, frac;
        for (dfi=0,gi=0; gi<n; gi++,dfi+=v)
        {
            fi = ulong(dfi);
            frac = dfi-double(fi);

            // linear interpolation:
            g[gi] = f[fi] + (f[fi+1]-f[fi])*frac;
        }
    }

    return n;
}
//=============== end ===============


ulong
sample_up_linear(const double *f, ulong nf, double v, double *g, ulong ng)
//
// uses linear interpolation (if noninteger v)
// returns number of values produced
//
{
    assert( v<=1.0 );

    ulong n = ulong(nf/v);  // n values will be produced
    if ( n>ng )  n = ng;

    ulong gi,fi;
    if ( v==floor(0.5+v) )  // ----- integer value
    {
        const ulong vi=ulong(floor(0.5+v));
        for (fi=0,gi=0; gi<n; gi++,fi+=vi)  g[gi] = f[fi];
    }
    else  // ----- non integer value
    {
        double dfi, frac;
        for (dfi=0,gi=0; gi<n; gi++,dfi+=v)
        {
            fi = ulong(dfi);
            frac = dfi-double(fi);

            // linear interpolation:
            g[gi] = f[fi] + (f[fi+1]-f[fi])*frac;
        }
    }

    return n;
}
//=============== end ================


ulong
resample_linear(const double *f, ulong nf, double v, double *g, ulong ng)
//
// uses linear interpolation (if noninteger v)
// returns number of values produced
//
{
    if ( v>=1.0 )  return sample_down_linear(f,nf,v,g,ng);
    else           return sample_up_linear(f,nf,v,g,ng);
}
//========== end ===========
