#if !defined __SHIFT_H
#define      __SHIFT_H


//#include "auxtempl.h"
#include "fxttypes.h"


template <typename Type>
void
shift_left(Type *f, ulong n, ulong s)
// shift towards element #0
{
    if ( s==0 )  return;
    if ( n==0 )  return;
    
    ulong k = 0;
    if ( n>s )  for (  ; k<n-s; ++k)  f[k] = f[k+s];
    for (  ; k<n; ++k)    f[k] = 0;
}
//-----------------------


template <typename Type>
void
shift_right(Type *f, ulong n, ulong s)
// shift away from element #0
{
    if ( s==0 )  return;
    if ( n==0 )  return;

    ulong k = n - 1;
    if ( n>s )  for (  ; k>=s; --k)  f[k] = f[k-s];
    do  { f[k]=0; }  while ( k-- );
}
//-----------------------


template <typename Type>
void
shift(Type *f, ulong n, long s)
{
    if ( s>0 )  shift_right(f,n, (ulong)s);
    else        shift_left(f,n, (ulong)-s);
}
//-----------------------


#endif // !defined __SHIFT_H
