#if !defined __SCALE2D_H
#define      __SCALE2D_H

#include "fxttypes.h"
#include "scale.h"
#include "minmax.h"

#include <math.h> // log()


template <typename Type>
void
linear_scale(Type **f, ulong nr, ulong nc,
             Type nmi, Type nma)   // new min, max
// linear scale so that
//   new_min==nmi,  ne_max==nma
{
    Type mi, ma;
    min_max((const Type **)f,nr,nc, &mi,&ma);
    for (ulong r=0; r<nr; ++r)  linear_scale(f[r],nc,mi,ma,nmi,nma);
}
//-----------------------

template <typename Type>
void
linear_scale(Type **f, ulong nr, ulong nc,
             Type mi, Type ma,     // old min, max
             Type nmi, Type nma)   // new min, max
// linear scale so that
//   new_min==nmi,  ne_max==nma
// supply (or pretend) old min and max
{
    for (ulong r=0; r<nr; ++r)  linear_scale(f[r],nc,mi,ma,nmi,nma);
}
//-----------------------


template <typename Type>
void
log_scale(Type **f, ulong nr, ulong nc,
          double xi, double xa, Type nma)
{
    Type mi, ma;
    min_max((const Type **)f,nr,nc, &mi,&ma);

    double ei = exp(xi), ea = exp(xa);
    linear_scale(f,nr,nc, mi, ma, ei, ea);

    for (ulong r=0; r<nr; ++r)
    {
        Type *p = f[r];
        ulong c = nc;
        while ( c-- )  p[c] = (Type)log((double)p[c]);
    }

    linear_scale(f,nr,nc, xi, xa, 0.0, nma);
}
//-----------------------


#endif // !defined __SCALE2D_H
