
#include <math.h>

#include "auxdouble.h"
#include "copy.h"
#include "auxbit.h"
#include "fxt.h"



void
fft_arblen(double *x, double *y, ulong n, int is)
//
// arbitrary length fft
//
{
    ulong ldnn = ld(n);
    if ( n==(1UL<<ldnn) )  ldnn += 1;
    else                   ldnn += 2;
    ulong nn = (1<<ldnn);

    double *fr = new double[2*nn];
    double *fi = fr + nn;

//    ri_copy(x,y,fr,fi,n);
    copy(x, fr, n);
    copy(y, fi, n);

//    ri_null(fr+n,fi+n,nn-n);
    null(fr+n, nn-n);
    null(fi+n, nn-n);

    double *wr = new double[2*nn];
    double *wi = wr + nn;

//    make_fft_fract_chirp(wr,wi,1.0*is,n,nn);
    make_fft_chirp(wr,wi,n,is);
    complete_fft_chirp(wr,wi,n,nn);

    ri_multiply(wr,wi,fr,fi,n);

    negate(wi,nn);
    fft_complex_convolution(wr,wi,fr,fi,ldnn);

//    make_fft_fract_chirp(wr,wi,1.0*is,n,nn);
    make_fft_chirp(wr,wi,n,is);
    complete_fft_chirp(wr,wi,n,nn);

    ri_multiply(fr,fi,wr,wi,nn);

//    ri_copy(wr+n,wi+n,x,y,n);
    copy(wr+n, x, n);
    copy(wi+n, y, n);

    delete [] wr;
    delete [] fr;
}
// ============== end ================
