
#include "fxt.h"
#include "sincos.h"
#include "fxtdefs.h"
#include "evenoddrevpermute.h"


static void
cos_rot(const double *x, double *y, ulong n)
{
    ulong nh = (n>>1);
    y[0]  = x[0];
    y[nh] = x[nh];
    double phi = M_PI/2/n;
    for (ulong k=1,j=n-1;  k<nh;  ++k,--j)
    {
        double c,s;
        sincos(phi*k, &s, &c);
        double p = (c+s) * SQRT1_2;
        double m = (c-s) * SQRT1_2;
        double xk = x[k],  xj = x[j];
        y[k] = m * xk + p * xj;
        y[j] = p * xk - m * xj;
    }
}
// =============== end =========== 

void
dcth(double *x, ulong ldn, double *tmp/*=0*/)
// transform wrt. basis: cos(k*(i+0.5)*PI/n) * (k==0?1.0:sqrt(2))
// H.Malvars algorithm: dct by fht
// if a (size-n) srcatchspace is supplied (tmp!=0)
// then the slightly faster version of inverse_evenoddrev_permute is used
{
    ulong n = (1<<ldn);

    double *y;
    if ( tmp )
    {
        y = tmp;
        inverse_evenoddrev_permute(x, y, n);
    }
    else
    {
        y = x;
        inverse_evenoddrev_permute(x, n);
    }
    
    fht(y,ldn);

    cos_rot(y, x, n);
}
// =============== end =========== 


void
idcth(double *x, ulong ldn, double *tmp/*=0*/)
// inverse transform wrt. basis: cos(k*(i+0.5)*PI/n) * (k==0?1.0:sqrt(2))
// H.Malvars algorithm: idct by fht
// if a (size-n) srcatchspace is supplied (tmp!=0)
// then the slightly faster version of inverse_evenoddrev_permute is used
{
    ulong n = (1<<ldn);
    
    double *y;
    if ( tmp )  y = tmp;
    else        y = x;

    cos_rot(x, y, n);
    
    fht(y,ldn);
    
    if ( tmp )  evenoddrev_permute(y, x, n);
    else        evenoddrev_permute(x, n);
}
// =============== end =========== 
