
#include <assert.h>

#include "fxt.h"
#include "evenoddpermute.h"


void
complex_to_real_imag(Complex *c, long n)
//
// this routine transforms
// complex data into two seperate fields
// with real and imag data (inplace)
//
{
    inverse_evenodd_permute((double *)c, 2*n);
}
//============= end  ============


void
real_imag_to_complex(double *fr, double *fi, long n)
//
// this routine transforms
// two seperate fields with real and imag
// data into complex data (inplace)
// (the data must lie in contiguous memory)
//
{
    assert( fi==fr+n ); // data MUST lie in contiguous memory
    evenodd_permute(fr, 2*n);
}
//============= end ============


void
complex_fft(Complex *c, ulong ldn, int is)
//
// FFT wrapper to use the routines that use the data
// in the real/imag form for type complex data
//
{
    const ulong n = (1<<ldn);

    double *fr = (double *)c;
    double *fi = fr + n;

    complex_to_real_imag(c,n);

    fht_fft(fr,fi,ldn,is);

    real_imag_to_complex(fr,fi,n);
}
//=========================== end ==========================


void
real_imag_fft(double *fr, double *fi, ulong ldn, int is)
//
// FFT wrapper to use the routines that use the data
// in the complex form for data in real/imag form
//
{
    const ulong n  = (1<<ldn);
    assert( fi==fr+n ); // data MUST lie in contiguous memory

    Complex *c = (Complex *)fr;

    real_imag_to_complex(fr,fi,n);

    //  here goes *YOUR* type Complex FFT:
    fht_fft(c,ldn,is);

    complex_to_real_imag(c,n);
}
//=========================== end ==========================

