
#include "fxt.h"
#include "fxtdefs.h"


void
fft_correlation0(double *f, double *g, ulong ldn)
//
// result in g
// 
{
    const ulong n=(1<<ldn);
    const ulong nh=(n>>1);  

    wrap_real_complex_fft0(f,ldn);  // jjnote: ugly: avoid wrap_*
    wrap_real_complex_fft0(g,ldn);

    const double v = 1.0/n;
    g[0]  *= f[0] * v;
    g[nh] *= f[nh] * v;

    for (ulong i=1,j=nh+1; i<nh; ++i,++j)
    {
        CMULT_N(f[i], -f[j], g[i], g[j], v);
    }

    wrap_complex_real_fft(g,ldn);
}
//============================= end =======================


void
fft_auto_correlation0(double *f, ulong ldn)
{
    const ulong n=(1<<ldn);
    const ulong nh=(n>>1);

    const double v = 1.0/n;

    wrap_real_complex_fft0(f,ldn);

    f[0]  *= f[0] * v;
    f[nh] *= f[nh] * v;

    for (ulong i=1,j=nh+1; i<nh; ++i,++j)
    {
        f[i] = (f[i]*f[i] + f[j]*f[j]) * v;
        f[j] = 0.0;
    }

    wrap_complex_real_fft(f,ldn);
}
//================ end =================
