
#include "fxt.h"
#include "fxtdefs.h"  // FHT_SQR()


void
fht_negacyclic_auto_convolution(double *x, ulong ldn, double v/*=0.0*/)
//
// v!=0.0 chooses alternative normalization
//
{
    if ( ldn==0 )
    {
        x[0] *= x[0];
        return;
    }    

    const ulong n = (1<<ldn);
    hartley_shift_05(x, n);
    fht(x, ldn);
    fht_negacyclic_auto_convolution_core(x, ldn, v);
    fht(x, ldn);
    hartley_shift_05(x, n);
}
// =========== end  ===========


void
fht_negacyclic_auto_convolution_core(double *x, ulong ldn, double v/*=0.0*/)
//
// v!=0.0 chooses alternative normalization
//
{
    const ulong  n  = (1<<ldn);
    const ulong  nh = n/2;

    if ( v==0.0 )  v = (1.0/n);
    v *= 0.5;

    for (ulong i=0,j=n-1; i<nh; i++,j--)
    {
        FHT_SQR(x[i], x[j], v);
    }
}
// ================ end ==============

