
#include "fxt.h"

#include <math.h>


void 
fht_spectrum(double *f, ulong ldn, int phasesq/*=0*/)
//
// power_spectrum computed with fht
// phasesq != 0  requests computation of phases
// phase[i] is in f[n-1]  (i=1...n/2-1)
// phase[0] == 0,  phase[n/2] == 0
//
// output is not normalized
{
    fht(f,ldn);

    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    if ( phasesq )
    {
        for (ulong i=1,j=n-1; i<nh; i++,j--)
        {
            double a = f[i] + f[j];
            double b = f[i] - f[j];
            f[i] = sqrt(a*a+b*b)*0.5;
            f[j] = atan2(b,a);
        }
    }
    else
    {
        for (ulong i=1,j=n-1; i<nh; i++,j--)
        {
            double a = f[i] + f[j];
            double b = f[i] - f[j];
            f[i] = sqrt(a*a+b*b)*0.5;
            f[j] = 0.0;
        }
    }

    f[0]  = fabs(f[0]);   // DC part
    if ( nh!=0 )  f[nh] = fabs(f[nh]);  // nyquist freq
}
// ============= end ============ 
