
#include "fxttypes.h"
#include "fxtdefs.h"
#include "misc.h"


inline void
fht_cnvl_core_core(const double *fp, const double *fm, double *gp, double *gm)
{
    double s1, d1;
    SUMDIFF4(*fp, *fm, s1, d1);
    double h2p = *gp,  h2m = *gm;
    *gp = h2p * s1 + h2m * d1;
    *gm = h2m * s1 - h2p * d1;
}
//===========================================


void
twodim_fht_convolution_core(const double *f, double *g, ulong r, ulong c)
//
//   ! UNTESTED !
//
{
    ulong rh = r/2;
    if ( r&1 )  rh++;
    
    ulong ch = c/2;
    if ( c&1 )  ch++;

    ulong n = r * c;
    for (ulong tr=1, ctr=c;  tr<rh;  tr++,ctr+=c)  // ctr = c*tr
    {
        const double *paf = f + ctr;
        const double *pbf = paf + c;
        const double *pcf = f + n - ctr;
        const double *pdf = pcf + c;

        double *pag = g + ctr;
        double *pbg = pag + c;
        double *pcg = g + n - ctr;
        double *pdg = pcg + c;

        for (ulong tc=1; tc<ch; tc++)
        {
            paf++;
            pbf--;
            pcf++;
            pdf--;

            pag++;
            pbg--;
            pcg++;
            pdg--;

            fht_cnvl_core_core(paf, pdf, pag, pdg);
            fht_cnvl_core_core(pbf, pcf, pbg, pcg);
        }
    }

    multiply(g, n, 0.5/n);
}
// =============== end =========== 
