
#include <math.h>
#include <iostream.h>
#include <stdlib.h>  // atol()

#include "fxt.h"
#include "fxtaux.h"

void fht_(double *);

int
main(int argc, char **argv)
{
    if ( argc<=1 )  exit(-1);
    const ulong ldn = atol(argv[1]);
    const ulong n = (1<<ldn);
//    cout << __PRETTY_FUNCTION__ << "():  ldn=" << ldn << "  n=" << n << endl;

    double f[4*n], g[4*n];
    for (ulong i=0; i<n; ++i)  f[i] = 0.271*i + white_noise();
    copy(f, g, n);

    fht_(f);
//    slow_ht(f,n);

    fht(g,ldn);
//    slow_ht(g,n);


    multiply(f, n, 1.0/sqrt(n));
    multiply(g, n, 1.0/sqrt(n));

    double err = rms_diff(f,g,n);
    cout << "ldn=" << ldn << "  n=" << n << "  err=" << err << endl;

    if ( err<1e-8 )
    {
        cout << "OK." << endl;
        return 0;
    }
    else
    {
        approx_eq(g, f, n, " *** ERROR *** ", 1e-10);
        return  -1;
    }
}
// ===================== end =====================
