
#include <math.h>

#include "copy.h"


// to do useful things:
// 1) replace all 'double' by 'int'
// 2) replace '*0.5' by '/2
// 3) erase calls to to 'floor()'


void
int_haar(double *f, ulong ldn, double *ws/*=0*/)
//
// transform wrt. to haar base
// integer input gives integer output
//
{
    ulong n = (1<<(ulong)ldn);

    double *g;
    if ( !ws )  g = new double[n];
    else        g = ws;

    for (ulong m=n; m>1; m>>=1)
    {
	ulong mh = (m>>1);
        for (ulong j=0,k=0; j<m; j+=2,k++)
        {
            double x = f[j];
            double y = f[j+1];

            double d = x-y;
            double s = y+floor(0.5*d); // == floor(0.5*(x+y));

            g[k]    =  s;
            g[mh+k] =  d;
        }

        copy(g,f,m);
    }

    if ( !ws )  delete [] g;
}
// ============= end  ===============


void
inverse_int_haar(double *f, ulong ldn, double *ws/*=0*/)
//
// inverse transform wrt. to haar base
// integer input gives integer output
//
{
    ulong n = (1<<(ulong)ldn);

    double *g;
    if ( !ws )  g = new double[n];
    else        g = ws;

    for (ulong m=2; m<=n; m<<=1)
    {
	ulong mh = (m>>1);

        for (ulong j=0,k=0; j<m; j+=2,k++)
        {
            double s = f[k];
            double d = f[mh+k];

            double y = s-floor(0.5*d);
            double x = d+y; // == s+floor(0.5*(d+1.0));

            g[j]    =  x;
            g[j+1]  =  y;
        }

        copy(g,f,m);
    }

    if ( !ws )  delete [] g;
}
// ============= end  ===============
