
#include "fxttypes.h"
#include "fxtaux.h" // copy()
#include "fxt.h" // hartley_shift_05()

#include <math.h>


static void
leftright(const double *a, double *le, double *ri, ulong n)
{
    for (ulong j=0; j<n; j++)
    {
        le[j] = a[j];
        ri[j] = a[n+j];
    }
}
// ================ end ====================


static void
recursive_dif2_fht_core(const double *a, ulong n, double *x)
{
    if ( n==1 )
    {
        x[0] = a[0];
        return;
    }

    ulong nh = n/2;

    double *b = new double[nh];
    double *c = new double[nh];
    double *le = new double[nh];
    double *ri = new double[nh];


    leftright(a, le, ri, nh);

    for (ulong k=0; k<nh; k++)
    {
        double t =   (le[k] + ri[k]);
        ri[k] =      (le[k] - ri[k]);
        le[k] = t;
    }

    hartley_shift_05(ri, nh);
    recursive_dif2_fht_core(le, nh, b);
    recursive_dif2_fht_core(ri, nh, c);

    for (ulong k=0, j=0; k<nh; k++,j+=2)
    {
        x[j]   = b[k];
        x[j+1] = c[k];
    }

    delete [] c;
    delete [] b;
    delete [] le;
    delete [] ri;
}
// ================ end ====================

void
recursive_dif2_fht(double *a, ulong ldn)
//
// very inefficient, just here to demonstrate the
// recursive fast hartley transform
//
{
    ulong n = (1<<ldn);
    double *x = new double[n];
    recursive_dif2_fht_core(a, n, x);
    copy(x,a,n);

    delete [] x;
}
// ================ end ====================

