
#include "fxt.h"
#include "auxbit.h"
#include "copy.h"


#define  FFT(re,im,ldn,is)   fht_fft(re,im,ldn,is)
#define  FFT0(re,im,ldn,is)  fht_fft0(re,im,ldn,is)

#define  FFTC(f,ldn,is)   fht_fft(f,ldn,is)
#define  FFT0C(f,ldn,is)  fht_fft0(f,ldn,is)


void
column_ffts(double *fr, double *fi, ulong r, ulong c, int is, 
            int zp, double *tmpr, double *tmpi)
//
// r x c matrix (r rows, c columns)
// length of each col is r
// length of each row is c
//
{
    double *wr, *wi;
    if ( tmpr )  wr = tmpr;
    else         wr = (double *)operator new( r * sizeof(double) );
    if ( tmpi )  wi = tmpi;
    else         wi = (double *)operator new( r * sizeof(double) );

    ulong rh = (r>>1);
    ulong ldr = ld(r);
    double *pr = fr,  *pi = fi;
    for (ulong k=0; k<c; ++k)
    {
        if ( zp )  //  skip_fft0(pr, pi, r, c, wr, wi, is);
        {
            skip_copy(pr, wr, rh, c);
            skip_copy(pi, wi, rh, c);
            null(wr+rh, rh);
            null(wi+rh, rh);
            FFT0(wr, wi, ldr, is);
        }
        else  // skip_fft(pr, pi, r, c, wr, wi, is);
        {
            skip_copy(pr, wr, r, c);
            skip_copy(pi, wi, r, c);
            FFT(wr, wi, ldr, is);
        }

        skip_copy_back(wr, pr, r, c);
        skip_copy_back(wi, pi, r, c);

        pr++;
        pi++;
    }

    if ( !tmpr )  operator delete(wr);
    if ( !tmpi )  operator delete(wi);
}
// ================== end ===================


void
column_ffts(Complex *f, ulong r, ulong c, int is, int zp, Complex *tmp)
//
// r x c matrix (r rows, c columns)
// length of each col is r
// length of each row is c
//
{
    Complex*w;
    if ( tmp )  w = tmp;
    else        w = (Complex *)operator new( r * sizeof(Complex) );

    ulong rh = (r>>1);
    ulong ldr = ld(r);
    Complex *p = f;
    for (ulong k=0; k<c; ++k)
    {
        if ( zp )  //  skip_fft0(p, r, c, wr, wi, is);
        {
            skip_copy(p, w, rh, c);
            null(w+rh, rh);
            FFT0C(w, ldr, is);
        }
        else  // skip_fft(pr, pi, r, c, wr, wi, is);
        {
            skip_copy(p, w, r, c);
            FFTC(w, ldr, is);
        }

        skip_copy_back(w, p, r, c);

        p++;
    }

    if ( !tmp )  operator delete(w);
}
// ================== end ===================


void
column_real_complex_ffts(double *f, ulong r, ulong c, int zp, double *tmp)
//
// r x c matrix (r rows, c columns)
// length of each col is r
// length of each row is c
//
{
    double *tr;
    if ( tmp )  tr = tmp;
    else        tr = (double *)operator new( r * sizeof(double) );

    for (ulong k=0; k<c; ++k)
    {
        if ( zp ) skip_real_complex_fft0(f, r, c, tr);
        else      skip_real_complex_fft(f, r, c, tr);
        f++;
    }

    if ( !tmp )  operator delete(tr);
}
// ================== end ===================


void
column_complex_real_ffts(double *f, ulong r, ulong c, double *tmp)
//
// r x c matrix (r rows, c columns)
// length of each col is r
// length of each row is c
//
{
    double *tr;
    if ( tmp )  tr = tmp;
    else        tr = (double *)operator new( r * sizeof(double) );

    ulong ldr = ld(r);
    for (ulong k=0; k<c; ++k)
    {
//        skip_complex_real_fft(f, r, c, tr);
        //  ==
        skip_copy(f, tr, r, c);
        fht_complex_real_fft(tr, ldr);
        skip_copy_back(tr, f, r, c);

        f++;
    }

    if ( !tmp )  operator delete(tr);
}
// ================== end ===================


void
column_complex_imag_ffts(const double *fr, double *fi, ulong r, ulong c, double *tmp)
//
// r x c matrix (r rows, c columns)
// length of each col is r
// length of each row is c
//
// only the imag part of the result is computed
//
{
    double *tr;
    if ( tmp )  tr = tmp;
    else        tr = (double *)operator new( 2*r * sizeof(double) );
    double *ti = tr + r;

    ulong ldr = ld(r);
    for (ulong k=0; k<c; ++k)
    {
        skip_copy(fr, tr, r, c);
        skip_copy(fi, ti, r, c);

        imaginator(tr, ti, r, +1);  // jjnote: isign dependence
        fht_complex_real_fft(ti, ldr);

        skip_copy_back(ti, fi, r, c);

        fr++;
        fi++;
    }

    if ( !tmp )  operator delete(tr);
}
// ================== end ===================

