
#include "fxt.h"
#include "ldn2rc.h"
#include "auxbit.h"
#include "revbinpermute.h"
#include "revbinpermute0.h"


// tuning parameter:
#define  USE_OLD_ALGORITHM    0  // 0 (revbin_permute for transpose)  or 1 
#define  USE_SPLRX  0  // whether split radix dif/dit is used (default=0)
//
#if  ( USE_OLD_ALGORITHM==1 )
#warning "FYI: using simple algorithm for matrix_auto_convolution(Complex *f, ...)"
#else  // USE_OLD_ALGORITHM
#warning "FYI: using revbin_permute for transpose for matrix_auto_convolution(Complex *f, ...)"
#if  ( USE_SPLRX==1 )
#warning 'FYI: matrix_complex_auto_convolution() uses split radix ffts'
#define  DIT_FFT_CORE  split_radix_fft_dit_core
#define  DIF_FFT_CORE  split_radix_fft_dif_core
#else
#warning 'FYI: matrix_complex_auto_convolution() uses radix 4 ffts'
#define  DIT_FFT_CORE  dit4_fft_core
#define  DIF_FFT_CORE  dif4_fft_core
#endif
#endif  // USE_OLD_ALGORITHM


void
matrix_auto_convolution(Complex *f, ulong ldn)
//
// f[] = f[] (*) f[]
//
{
    ulong r, c;
    ldn2rc(ldn,r,c);
    matrix_auto_convolution(f, r, c, 0);
}
// =========== end ============


void
matrix_auto_convolution0(Complex *f, ulong ldn)
//
// f[] = f[] (*) f[]
// version for zero padded data
//
{
    ulong r,c;
    ldn2rc(ldn,r,c);
    matrix_auto_convolution(f, r, c, 1);
}
// =========== end ============


void
matrix_auto_convolution(Complex *f, ulong r, ulong c, int zp/*=0*/)
//
// f[] = f[] (*) f[]
//
{
#if ( USE_OLD_ALGORITHM==1 )

    const ulong n = c * r;
    const int is = 1;

    Complex *t = (Complex *)operator new (r*sizeof(Complex));  // jjnote: mem allocation

    column_ffts(f, r, c, is, zp, t);
    double v = 1.0/n;
    row_weighted_auto_convolutions(f, r, c, v);
    column_ffts(f, r, c, -is, 0, t);

    operator delete(t);

#else  // USE_OLD_ALGORITHM

    const ulong n = c * r;
    ulong ldr = ld(r),  ldc = ld(c);

    if ( zp ) revbin_permute0(f, n);
    else      revbin_permute(f, n);
    swap(r, c);
    swap(ldr, ldc);

    const int is = -1;  // must be -1
    ulong k;
    Complex *tf;
    for (k=0, tf=f; k<r; ++k, tf+=c)
    {
        DIT_FFT_CORE(tf, ldc); // is = -1
        ulong rk = revbin(k, ldr);
        fourier_shift(tf, c, is*1.0*rk/r);
    }

    revbin_permute(f, n);
    swap(r, c);
    swap(ldr, ldc);

    double v = 1.0/n;
    for (k=0, tf=f; k<r; ++k, tf+=c)
    {
        split_radix_dif_fht_core(tf, ldc);
        fht_auto_convolution_revbin_permuted_core(tf, ldc, v);
        split_radix_dit_fht_core(tf, ldc);

//        fft_auto_convolution(tf, ldc, v);

//        DIF_FFT_CORE(tf, ldc); // is = +1
//        for (ulong i=0; i<c; ++i)
//        {
//            Complex t = tf[i];
//            t *= t;
//            tf[i] = t * v;
//        }
//        DIT_FFT_CORE(tf, ldc); // is = -1
    }

    revbin_permute(f, n);
    swap(r, c);
    swap(ldr, ldc);

    for (k=0, tf=f; k<r; ++k, tf+=c)
    {
        ulong rk = revbin(k, ldr);
        fourier_shift(tf, c, -is*1.0*rk/r);
        DIF_FFT_CORE(tf, ldc); // is = +1
    }

    revbin_permute(f, n);
#endif  // USE_OLD_ALGORITHM
}
// =========== end ============


void
matrix_complex_auto_convolution(double *fr, double *fi, ulong ldn)
//
// f[] = f[] (*) f[]  where f[] := (fr[], fi[])
//
{
    ulong r, c;
    ldn2rc(ldn, r, c);
    matrix_complex_auto_convolution(fr, fi, r, c);
}
// =========== end ============

void
matrix_complex_auto_convolution0(double *fr, double *fi, ulong ldn)
//
// f[] = f[] (*) f[]  where f[] := (fr[], fi[])
// version for zero padded data
//
{
    ulong r,c;
    ldn2rc(ldn,r,c);
    matrix_complex_auto_convolution(fr, fi, r, c, 1);
}
// =========== end ============


void
matrix_complex_auto_convolution(double *fr, double *fi, ulong r, ulong c, int zp/*=0*/)
//
// f[] = f[] (*) f[]  where f[] := (fr[], fi[])
//
{
    const ulong n = c * r;
    const int is = 1;

    double *tr = (double *)operator new (2*r*sizeof(double));  // jjnote: mem allocation
    double *ti = tr + r;

    column_ffts(fr, fi, r, c, is, zp, tr, ti);
    double v = 1.0/n;
    row_weighted_auto_convolutions(fr, fi, r, c, v);
    column_ffts(fr, fi, r, c, -is, 0, tr, ti);

    operator delete(tr);
}
// =========== end ============
