#if !defined __FACTOR_H
#define      __FACTOR_H


#include "mtypes.h"

class ostream;
class istream;


class  factorization
{
    friend class mod_init;

public:
    factorization();
    factorization(umod_t n);
    factorization(umod_t n, umod_t*f);
    ~factorization();

    void make_factorization(umod_t n);
    void make_factorization(umod_t n, umod_t*f);
    int  is_factorization_of(umod_t n) const;
    int  exponent(umod_t f) const;
    int  is_prime() const;
    umod_t product() const;
    umod_t factor(int i) const;

    void print(const char *bla, ostream &os) const;

    void  check();

//private:
    umod_t *prime;
    long   *expon;
    int     npr;
    umod_t *fact;
    umod_t  prod;

private:
    static const int  maxprimes;

    void reset();
    void sort();
    void ctor_core();

    factorization(const factorization &); // forbidden
    const factorization & operator = (const factorization &); // forbidden
};
// ----------------


inline int
factorization::is_prime() const
{
    return ((1==npr) && (1==expon[0]));
}
// ----------------

// factor.cc:
umod_t is_factor(umod_t n, umod_t f);
long divide_out_factor(umod_t &n, umod_t v);
umod_t int_sqrt(umod_t d);

//istream&  operator >> (istream& is, factorization& h);
ostream&  operator << (ostream& os, const factorization& h);


#endif  // !defined __FACTOR_H
