
#include "jjassert.h"

#include "mod.h"
#include "modm.h"
#include "factor.h"


umod_t
maxorder_mod(const factorization &modfact)
//
// let m = 2^e0 * \prod_i{p_i^{e_i}}  i=1...k
//
// let f0 = 2^e0      if    e0 \in {0,1,2} 
//        = (2^e0)/2  else
//
// let fi = phi(p_i^{e_i}) = (p_i-1) * p_i^{e_i-1}
//
// then maxorder = lcm_i(f0,f1,f2,...,fk)
//
{
    int k = 0;
    umod_t m = 1;
    if ( modfact.prime[0]==2 )
    {
        int e = modfact.expon[0];
        m = (1ULL<<(e-1));
        if ( modfact.expon[0] >= 3 )  m >>= 1;
        k++;
    }

    while ( k<modfact.npr )
    {
        umod_t f = phi(modfact.prime[k],modfact.expon[k]);
        m = lcm(m,f);
        k++;
    }
    
    return m;
}
//================= end ================


umod_t
maxorder_element_mod(const factorization &modfact, const factorization &phifact)
//
// find element of maximal order
//
{
    umod_t m = modfact.product();
    if ( m==2 )  return 1;

    umod_t x = 0;
    umod_t mo = maxorder_mod(modfact);

    // first search small primes:
    int i = 0;
    while ( 0 != (x=prime(i)) )
    {
        // cannot happen, maxorder element is found before:
        jjassert2( x<m , "maxorder_element() failed." );

        i++;
	if ( order_mod(x,m,phifact)==mo )  return x;
    }

    // rarely ever reached:
    while (  (x+=2) < m )
    {
	if ( order_mod(x,m,phifact)==mo )  return x;
    }

    jjassert2( 0, "maxorder_element() failed." );
    return 0;
}
//================= end ================
