
#include <math.h>
#include <iostream.h>
#include <stdlib.h>  // rand()

#include "mod.h"
#include "modm.h"
#include "ntt.h" // double_to_mod_by_force
#include "jjassert.h"


void
copy(const mod *src, mod *dst, ulong n)
{
    while ( n-- )  dst[n] = src[n];
}
//-------------------------------------------


//void
//fill(mod *dst, ulong n, mod src)
//{
//    while ( n-- )  dst[n] = src;
//}
////-------------------------------------------


void
multiply(mod *f, ulong n, mod m)
{
    while ( n-- )  f[n] *= m;
}
//-------------------------------------------


void
print(char *bla, const mod *f, ulong n)
{
    if ( bla )  cout << "\n" << bla << endl;

    for (ulong i=0; i<n; ++i)
    {
	cout << i << ": " << f[i] << endl;
    }
}
//-------------------------------------------


ulong
diff_print(mod *f, mod *g, ulong n, int supreq/*=1*/)
{
//    cout << "diff_print(): " << endl;
    ulong ret = 0;

    for (ulong i=0; i<n; ++i)
    {
	if ( f[i]!=g[i] )
	{
	    ret++;
	    cout.width(4);
            cout << i << ": "; 
            cout.width(20);
            cout << f[i] << " !diff! " ;
            cout.width(20);
            cout << g[i] << endl;
	}
	else  if ( !supreq )
	{
	    cout.width(4);
	    cout << i << ": "; 
            cout.width(20);
            cout << f[i] << " ------ " ;
            cout.width(20);
            cout << g[i] << endl;
	}
    }

//    if ( ret==0 )  cout << " OK. " << endl;

    return ret;
}
//-------------------------------------------


ulong
diff(mod *src, mod *dst, ulong n)
{
    ulong ret=0;

    for (ulong i=0; i<n; ++i)
    {
	dst[i] -= src[i];

	if ( ret==0 )  ret=i+1;
    }

    return ret;
}
//-------------------------------------------


//void
//rand(double *f, ulong n, umod_t m)
//{
//    for (ulong i=0; i<n; ++i)
//    {
//        f[i] = 0.0+((m-1.0)*rand()/(RAND_MAX+1.0));
//    }
//}
////-------------------------------------------


void
rand(mod *f, ulong n, umod_t m)
{
    for (ulong i=0; i<n; ++i)
    {
        umod_t t = (umod_t)((double)(m-1)*rand()/(RAND_MAX+1.0));
//        jjassert( t>=0 );
        jjassert( t<m );
        f[i] = t;
    }
}
//-------------------------------------------



ulong
diff_print(double *f, double *g, ulong n)
{
    double_to_mod_by_force(f,n);
    double_to_mod_by_force(g,n);
    return diff_print((mod*)f,(mod*)g,n);
}
//-------------------------------------------
