
#include "ntt.h"
//#include "modm.h"

#define LX 2

void
ntt_dit4(mod *f, ulong ldn, int is)
//
// radix 4 decimation in time mod fft
//
{
    const ulong n = (1<<ldn);

    revbin_permute(f,n);

    // n is not a power of 4, need a radix 2 step:
    if ( (ldn&1)!=0 )  sumdiff2(f,n);

    const mod imag = mod::root2pow( is>0?2:-2 );

    ulong ldm = LX+(ldn&1);

    for ( ; ldm<=ldn ; ldm+=LX)
    {
        const ulong m = (1<<ldm);
        const ulong m4 = (m>>LX);

	const mod dw = mod::root2pow( is>0?ldm:-ldm );
	mod w = (mod::one);
	mod w2 = w;
	mod w3 = w;

        for (ulong j=0; j<m4; j++)
        {
            for (ulong r=0, i0=j+r; r<n; r+=m, i0+=m)
            {
		const ulong i1 = i0+m4;
		const ulong i2 = i1+m4;
		const ulong i3 = i2+m4;

		mod a0 = f[i0];
		mod a2 = f[i1]*w2;
		mod a1 = f[i2]*w;
		mod a3 = f[i3]*w3;

		mod t02 = a0+a2;
		mod t13 = a1+a3;

		f[i0] = t02+t13;
		f[i2] = t02-t13;

		t02 = a0-a2;
		t13 = a1-a3;
		t13 *= imag;

		f[i1] = t02+t13;
		f[i3] = t02-t13;
            }

	    w *= dw;
	    w2 = w*w;
	    w3 = w*w2;
        }
    }
}
// ==================== end ===================
