
#include <math.h>

#include "mtypes.h"
#include "modm.h"
#include "jjassert.h"


void
n2qt(const umod_t n, umod_t &q, int &t)
// set q,t so that  n-1 == q * 2^t
{
    q = n - 1;
    t = 0;

    while ( 0==(q&1) )
    {
        q >>= 1;
        t++;
    }
}
//================= end ================


int
rabin_miller_pass(const umod_t n, const umod_t a, const umod_t q, const int t)
// return 1 =--> passed
{
    umod_t b = pow_mod(a,q,n);

    if ( 1==b )  return 1;  // passed

    // squarings:
    int e = 1;
    while ( (b!=1) && (b!=(n-1)) && (e<t) )
    {
        b = mul_mod(b,b,n);
        e++;
    }

    if ( b!=(n-1) )  return 0;  // =--> COMPOSITE

    return 1;  // passed
}
//================= end ================


int
is_pseudoprime(umod_t n, uint cm/*=0*/)
//
// rabin miller test
// return 1 if n is (with probability (1/4)^cm) prime
// cf. cohen p.414
//
{
    if ( 0==(n&1) )  // n even
    {
        if ( 2==n )  return 1;  // prime
        else         return 0;  // composite
    }

    if ( n<1000 )  // eliminate tiny n
    {
        uint s = (uint)sqrt(n);
        uint v;
        for (v=3; v<=s; v+=2)
        {
            if ( ((n/v)*v)==n )  return 0;  // =--> COMPOSITE
        }

        return 1;  // prime
    }


    // initialize q,t so that  n == q * 2^t + 1
    umod_t q;
    int t;
    n2qt(n,q,t);

    if ( cm==0 )  cm = 20;  // default

    uint c = 0;
    while ( c<cm )
    {
        // choose new a:
        umod_t a = prime(c);
        jjassert2( (a!=0), "is_prime(): need more primes ! " );

        if ( !rabin_miller_pass(n, a, q, t) )  return 0;  // =--> COMPOSITE

        c++;
    }

    return 1;  // strong pseudo prime
}
//================= end ================
