
#include "fxtmult.h"
#include "auxbit.h"

#include "jjassert.h"


ulong
next_dfxtlen(ulong n)
{
    ulong n2 = (1<<ld(n));
    if ( n2<n )  n2 <<= 1;
    return n2;
}
//----------------------

ulong
previous_dfxtlen(ulong n)
{
    return  (1<<ld(n));
}
//----------------------


ulong
sum_of_digits(const double *a, ulong n,
              double nine, ulong su)
{
    double s = su;

    for (ulong k=0; k<n; ++k)
    {
        s += a[k];
        if  ( s>=nine )  s -= nine;

//        jjassert( a[k]<=nine );
//        jjassert( a[k]>=0 );
    }

    return (ulong)s;
}
//----------------------


ulong
sum_of_digits(const LIMB *a, ulong n,
              ulong nine, ulong s)
{
//    if ( s )  jjassert( s<nine );

    for (ulong k=0; k<n; ++k)
    {
        s += a[k];
        if  ( s>=nine )  s -= nine;

//        if ( s )  jjassert( s<nine );
    }

    return s;
}
//----------------------


ulong
mult_sum_of_digits(const LIMB *a, ulong an,
                   const LIMB *b, ulong bn,
                   ulong nine)
{
    ulong qsa = sum_of_digits(a, an, nine, 0);
    ulong qsb = sum_of_digits(b, bn, nine, 0);
    ulong qsm = (qsa*qsb) % nine;
    return  qsm;
}
//----------------------


ulong
sqr_sum_of_digits(const LIMB *a, ulong an,
                  ulong nine)
{
    ulong qsa = sum_of_digits(a, an, nine, 0);
    ulong qsm = (qsa*qsa) % nine;
    return  qsm;
}
//----------------------

