#if !defined __DISKAUX_H
#define      __DISKAUX_H

#include "fxttypes.h"   // for ulong, LIMB

// diskaux.cc:
void open_err(const char *fn, int *fd);
void close_err(int fd);

void seek_read(int fd1, ulong off, double *f, ulong fn);
void v_seek_read(int fd1, ulong off, void *f, ulong fn);
void seek_write(int fd1, ulong off, double *f, ulong fn);
void v_seek_write(int fd1, ulong off, void *f, ulong fn);

// diskaux2.cc:
void zeroes2disk(double *f, ulong fn, ulong al,
                 int fd, ulong off=0);

void limb2disk(const LIMB *a, ulong an,
               double *f, ulong fn, ulong al,
               int fd);

void disk_carry_thru_2limb(double *f, ulong fn, ulong al,
                           int fd1,
                           uint rx, ulong &cy,
                           LIMB *c, ulong cn, ulong coff,
                           ulong &sod);


#endif // !defined __DISKAUX_H
