
#include "fxt.h"
#include "fxtdefs.h"
#include "diskaux.h"
#include "misc.h" // multiply()
#include "auxbit.h"


#define  FFT(fr,fi,ldn,is)  fht_fft(fr,fi,ldn,is)


void
disk_row_pass(int fd1, int fd2,
              double *fr, double *fi,
              ulong nr, ulong nc,
              double nx/*=0*/)
//
// nx: additional normalization factor
//
{
    const int is = +1;  // MUST be same as in disk_column_pass()

    ulong ldnc = ld(nc);
    double *pr = fr,  *pi = fi;
    double nn = 1.0/(nc*nr);
    if ( 0.0!=nx )  nn *= nx;
    for (ulong r=0,k=0; r<nr; ++r,k+=nc)  // k=r*nc
    {
        seek_read(fd1, k, pr, nc);
        seek_read(fd2, k, pi, nc);

        double w = (double)r/nr;

        fourier_shift(pr, pi, nc, w);
        FFT(pr, pi, ldnc, is);

        for (ulong j=0; j<nc; j++)  CSQR2(pr[j], pi[j]);

        FFT(pr, pi, ldnc, -is);
        fourier_shift(pr, pi, nc, -w);

        multiply(pr, nc, nn);
        multiply(pi, nc, nn);

        seek_write(fd1, k, pr, nc);
        seek_write(fd2, k, pi, nc);
    }    
}
// ================== end ===================
    
