
#include "fxt.h"
#include "fxtmult.h"
#include "workspace.h"
#include "auxtempl.h" // max
#include "jjassert.h"

#include <iostream.h>
#include <math.h>  // log()


#define  USE_NTT  0  // 0 or 1, default is 0 (NTT is slow !)

#define  USE_MATRIXFFT  0  // 0 or 1

// saving characters:
#define  CACHE_SQR  void (* fxtmult::sqrcnvl1)(double *, ulong)
#define  MEM_SQR    void (* fxtmult::sqrcnvl2)(double *, ulong)
#define  CACHE_MUL  void (* fxtmult::mulcnvl1)(double *, double *, ulong)
#define  MEM_MUL    void (* fxtmult::mulcnvl2)(double *, double *, ulong) 

#if  ( USE_NTT==0 )

CACHE_SQR = fht_auto_convolution0;
CACHE_MUL = fht_convolution0;

#if  ( USE_MATRIXFFT==0 )
#warning 'FYI: usual FFT is used if size>cachesize'
//MEM_SQR = fht_auto_convolution0;
//MEM_MUL = fht_convolution0;

MEM_SQR = split_radix_fft_auto_convolution0;
MEM_MUL = split_radix_fft_convolution0;

#else  // USE_MATRIXFFT
#warning 'FYI: matrix FFT is used if size>cachesize'
MEM_SQR  = matrix_auto_convolution0;
MEM_MUL  = matrix_convolution0;
#endif  // USE_MATRIXFFT

#else  // USE_NTT
#include "mfft.h"
CACHE_SQR = fft_mod_auto_convolution;
CACHE_MUL = fft_mod_convolution;
MEM_SQR   = fft_mod_auto_convolution;
MEM_MUL   = fft_mod_convolution;
#endif  // USE_NTT


#define  USE_DEV_FILES  0  // 0 (regular files) or 1 (devices, !DANGER!)

#if  ( USE_DEV_FILES==0 )
const char * const fxtmult::filename1 = "/tmp/massstorage1.bin";
const char * const fxtmult::filename2 = "/tmp/massstorage2.bin";
#else  // USE_DEV_FILES
#warning '*****************************************'
#warning '! using devices for mass storage FFTs !  '
#warning '! you absolutely MUST know what this     '
#warning '! technically means or +++ STOP NOW +++  '
#warning '*****************************************'
#error   ' =-->  EDIT THIS FILE TO PROCEED '
const char * const fxtmult::filename1 = "/dev/hda2";
const char * const fxtmult::filename2 = "/dev/hda3";
#endif  // USE_DEV_FILES

int     fxtmult::checkmult = 1;
int     fxtmult::verbosity = 0;

double  fxtmult::fxtwork = 0.0;
double  fxtmult::diskio = 0.0;
double  fxtmult::diskiotime = 0.0;
double  fxtmult::ndiskseeks = 0.0;

const char * const fxtmult::classname = "fxtmult";


int // static
fxtmult::multiply(const LIMB *a, ulong an,
                  const LIMB *b, ulong bn,
                  LIMB *c, ulong cn,
                  uint rx)
{
    ulong al = alpha_mul(an, bn);

    if ( al<=1 )  // convolution in memory
    {
        return fxt_multiply(a, an, b, bn, c, cn, rx);
    }
    else  // mass storage convolution
    {
        ulong fn = max_noswap_dfxtlen();
        ulong i = disk_multiply(a, an, b, bn, c, cn, rx, fn, al);
        return i;
    }
}
//-------------------------------

    
int // static
fxtmult::square(const LIMB *a, ulong an,
                LIMB *c, ulong cn,
                uint rx)
{
    ulong al = alpha_sqr(an);

    if ( al<=1 )  // convolution in memory
    {
        return fxt_square(a, an, c, cn, rx);
    }
    else  // mass storage convolution
    {
        ulong fn = max_noswap_dfxtlen();
        ulong i = disk_square(a, an, c, cn, rx, fn, al);
        return i;
    }
}
//-------------------------------


ulong  // static
fxtmult::max_noswap_dfxtlen()
{
    return  previous_dfxtlen( workspace::noswap_doubles() );
}
//-------------------------------

ulong // static
fxtmult::max_cache_dfxtlen()
{
    return  previous_dfxtlen( workspace::cache_doubles() );
}
//-------------------------------

ulong // static
fxtmult::ndoubles_fxtsqr(ulong an)
{
    return next_dfxtlen(2*an);
}
//-------------------------------

ulong // static
fxtmult::ndoubles_fxtmul(ulong an, ulong bn)
{
    return 2*next_dfxtlen(2*max(an,bn));
}
//-------------------------------

ulong // static
fxtmult::alpha_mul(ulong an, ulong bn)
{
    ulong n = ndoubles_fxtmul(an,bn);
    ulong fn = max_noswap_dfxtlen();
    ulong al = n/fn;
    if ( al*fn!=n )  ++al;
    return al;
}
//-------------------------------

ulong // static
fxtmult::alpha_sqr(ulong an)
{
    ulong n = ndoubles_fxtsqr(an);
    ulong fn = max_noswap_dfxtlen();
    ulong al = n/fn;
    if ( al*fn!=n )  ++al;
    return al;
}
//-------------------------------

double // static
fxtmult::swapfile_bytes(ulong an)
{
    ulong al = alpha_mul(an,an);
    ulong fn = max_noswap_dfxtlen();
    if ( al>1 )  return  0.5 * al * fn * sizeof(double);
    else         return  0;
}
//-------------------------------


void // static
fxtmult::print_info(ulong n/*=0*/)
{
    cout << " fxtmult: fxt multiplies ";
    if ( checkmult )  cout << "ARE ";
    else              cout << "are NOT ";
    cout << "checked via sum of digit test " << endl;

    if ( n!=0 )
    {
        double dn = swapfile_bytes(n);
        if ( dn!=0 )
        {
            cout << " fxtmult: swapfile1 is \"" << filename1 << "\"" << endl;
            cout << " fxtmult: swapfile2 is \"" << filename2 << "\"" << endl;
            cout << " fxtmult: max swapfile size will be (2x) "
                 << dn/(1024*1024) << " MB" << endl;
        }
        else
        {
            cout << " fxtmult: max workspace size for fxt mult will be "
                 << ndoubles_fxtmul(n,n)*sizeof(double) << " bytes " << endl;
        }
    }
}
//-------------------------------


void // static
fxtmult::print_statistics(ulong n/*=0*/)
{
    const double fftMwork = 1024.0 * 1024.0 * 20;
    cout << " fxtmult: work was=" << fxtwork / fftMwork
         << " times length 2^20 real FFTs" << endl;

    if ( n )
    {
        const double fftnwork = 2*n*log(2*n)*(1.0/log(2.0));
        cout << " fxtmult: == " << fxtwork/fftnwork << " full prec real FFTs" << endl;
//        cout << " fxtmult: == " << fxtwork/(3.0*fftnwork) << " full prec mults" << endl;
    }

    if ( 0.0 != diskio )
    {
        cout << " fxtmult: disk I/O was " << diskio/(1024.0 * 1024.0) << " MB" << endl;
        cout << " fxtmult: disk I/O time was " << diskiotime << endl;
        cout << " fxtmult: # of disk seeks was " << ndiskseeks << endl;
    }
}
//-------------------------------
