
#define RGK  << (r>k ? "*" : "_") <<
void
revbin_permute_(double *f, ulong n)
{
    cout << "=========" << endl;
    if ( n<=2 )  return;

    const ulong nh = (n>>1),  n4 = nh/2;
    double * const f1 = f + n - 1;

    ulong ldn = ld(n);
    ulong k=0, r=0;
    while ( k<nh  )
    {
        if ( k==n4 )  cout << "-----------" << endl;
        // k even:
   	if ( r>k )
        {
            swap(f[k], f[r]);     // k<nh, r<nh
            swap(f1[-k], f1[-r]); // n-k>nh, n-r>nh
            cout << "e" RGK "  k=" << k << "  r=" << r
                 << "  d=" << (long)r-(long)k
                 << "    -k=" << n-1-k << "  -r=" << n-1-r
                 << endl;
        }

        // k odd:
        ++k;
        r += nh;
        swap(f[k], f[r]);  // k<nh, r>nh
        cout << " " RGK "  k=" << k << "  r=" << r
             << "  d=" << (long)r-(long)k
             << endl;

        ++k;
        ulong ro = r;
        r ^= nh;
        for (ulong m=(nh>>1); !((r^=m)&m); m>>=1)
        {
//            cout << " ^^" << m << " ";
        }
//        cout << "  ^" << revbin((ro^r), ldn) << endl;
    }
}
//============== end =================

void
swap(double *f, double *g, ulong i, ulong r, ulong b)
{
    for (ulong k=0; k<b; ++k)
    {
        ulong t1 = i*b+k,  t2 = r*b + k;
        cout << "  (" << t1 << " <--> " << t2 << ")" << endl;
        swap(f[t1], g[t2]);
    }
}
//============== end =================

void
revbin_permute(double *f, ulong n, ulong b)
{
    n /= b;

    cout << "====b=====" << endl;
    if ( n<=2 )  return;

    const ulong nh = (n>>1),  n4 = nh/2;
    double * const f1 = f + n - 1;

    ulong ldn = ld(n);
    ulong k=0, r=0;
    while ( k<nh  )
    {
        if ( k==n4 )  cout << "-----------" << endl;
        // k even:
   	if ( r>k )
        {
            swap(f,f, k,r, b);          // k<nh, r<nh
            swap(f,f, n-1-k, n-1-r, b); // n-k>nh, n-r>nh
            cout << "e" RGK "  k=" << k << "  r=" << r
                 << "  d=" << (long)r-(long)k
                 << "    -k=" << n-1-k << "  -r=" << n-1-r
                 << endl;
        }

        // k odd:
        ++k;
        r += nh;
        swap(f,f, k,r, b);  // k<nh, r>nh
        cout << " " RGK "  k=" << k << "  r=" << r
             << "  d=" << (long)r-(long)k
             << endl;

        ++k;
        ulong ro = r;
        r ^= nh;
        for (ulong m=(nh>>1); !((r^=m)&m); m>>=1)
        {
//            cout << " ^^" << m << " ";
        }
//        cout << "  ^" << revbin((ro^r), ldn) << endl;
    }
}
//============== end =================


void
test_revbin_permute(double *f, ulong n)
// inplace version
// operation count is n*log_2(n)
{
    for (ulong h=n/2; h>=2; h/=2)
    {      
        for (double *p = f+n-h;  p>f;  p-=2*h)
        {
//            reverse(p, h);
            revbin_permute(p-h, h);
            revbin_permute(p, h);
        }
    }
}
// ================= end ==================

#define  TG(x)  x //<< ((x)==r ? "*" : "-")
void
grscr(double *fr, ulong x)
{
    for (ulong k=0; k<x; ++k)
//    for (ulong k=x-1; k>0; --k)
    {
//        ulong r = graycode(k);
        ulong r = k^(k>>1);
//        ulong r = k^(k<<1) ^ x;

        ulong y = graycode(graycode(k));
        ulong r2 = graycode(r), r3 = graycode(r2);

        if ( r>k )
        {
            cout << "swap:  ";
//            assert( fr[k]>=0 );
//            assert( fr[r]>=0 );
            swap(fr[k], fr[r]);
//            fr[k] = -fr[k];  fr[r] = -fr[r];

//            if ( y<r

        }
        else        cout << "       ";

        cout << fr[k] << " [k=" << k << "] <-"
//             << (1)
             << "-> [" << r << "] " << fr[r]
//             << "      " << r2
//             << "      " << r3
             << "      " << y
             << endl;
    }
    cout << endl;
}
//===========================


#define  perf  mcode

ulong mcode(ulong k, ulong n)
{
    if ( !(k&1) )   k = k/2;
    else            k = n/2 + (k-1)/2;
    return k;
}
//===========================

ulong imcode(ulong k, ulong n)
{
    if ( !(k&1) )  k =  k/2;
    else           k =  n-(k+1)/2;
    return k;
}
//===========================


ulong gcode(ulong k, ulong)
{
    return graycode(k);
}
//===========================

ulong ri2c(ulong k, ulong n)
{
    if ( k>=n/2 )  return  2*k-n+1;
    else           return  2*k;
}
//===========================

ulong c2ri(ulong k, ulong n)
{
    if ( k&1 )  return  n/2+k/2;
    else          return  k/2;
}
//===========================

void
jj(ulong k)
{
//    cout.width(3);  cout << k;  return;

    static ulong m = (1UL<<31);
    ulong z = 31;
//    if ( k )  while ( !(k&m) )  k <<= 1, --z;
    z = 8;  k <<= (31-z);

    do
    {
        cout << ( k&m ? '1' : '0' );
        k <<= 1;
    }
    while ( z-- );
}
//===========================================

ulong
search_idx(double *f, ulong n, double v)
{
    for (ulong k=0; k<n; ++k)
    {
        if ( f[k]==v )  return k;
    }
    abort();
    return 0;
}
//===========================================

void
idx_diff(double *f, ulong n)
{
    for (ulong k=0; k<n; ++k)
    {
        long i1 = search_idx(f, n, k);
        long i2 = k; //search_idx(f, n, k+1);
        cout << "d[" << k << "]=" << i2-i1 << endl;
    }
}
//===========================================

void
permute(double *ar, ulong n)
{
    cout << "--- n=" << n << endl;
    ulong ks, ko, kn;
    ko = ks = 0;
    jj(ko);
    while ( 1 ) //ko<n-1 )
    {
        kn = perf(ko,n);
        cout << " ";
        jj(kn);

        if ( ar[kn] )
        {
            cout << "\n stop @ " << kn << endl;
//            break;
        }

        ar[kn]++;
        if ( kn<=ks || kn>=n )
        {
//            cout << " <";
//            jj(kn);
//            cout << ">";
            ulong p = 0;
            do
            {
                ++p;
                if ( 0 && p>1 )
                {
                    cout << endl;
                    cout << " {";
                    jj(ks);
                    cout << " --> ";
                    jj( perf(ks, n) );
                    cout << "}";
                }
                ks += 1;
                if ( ks>=n )
                {
                    cout << " [" << p << "]" << endl;
                    goto zulp;
                }
            }
            while ( ar[ks] );

            cout << " [" << p << "]" << endl;

            ko = ks;
            jj(ko);
            continue;
        }

        ko = kn;
    }
 zulp:
    cout << endl;

    for (ulong k=1; k<n-1; ++k)
    {
        if ( ar[k]!=1 )  cout << "[" << k << "]=" << ar[k] << endl;
    }
}
//====================================
