#include <math.h>
#include <stdlib.h>
#include <assert.h>
#include <iostream.h>

#include "fxt.h"
#include "fxtaux.h"
#include "image.h"
#include "waveletfilter.h"


#define X01(x)   (x>0?1:0)
#define SIGN(x)  ((x)>0?1:((x)<0?-1:0))
//#define ABS(x)   ((x)>=0?(x):-(x))

#include "testaux.cc"
#include "jjassert.h"

int seqct(uint *f, uint n)
{ int ct=0; for (uint k=0; k<n-1; ++k) if (f[k]!=f[k-1]) ct++;  return ct; };  


#define  UINTIMG  0

int
main(int argc, char **argv)
{
    ulong ldn = 5;
    if ( argc>1 )  ldn=atoi(argv[1]);
    long n=(1<<ldn);

#if  ( 1==UINTIMG )
    int   f[n],g[n];
    int   img[n*n];
#else
    double f[n],g[n];
    double img[n*n];
#endif

    long k;
    for (k=0; k<n; k++)
    {
        for (long i=0; i<n; ++i )  f[i] = g[i] = 0;
        f[k] = g[k] = 1;
//        f[(n-k)%n] = 1;
//        fill(f,k,1.0);
//        for (long i=0; i<n; ++i )  f[i] = SIGN(cos(1.0*PI*k*i/n));
//        for (long i=0; i<n; ++i )  f[i] = cos(1.0*PI*k*i/n);
//        for (long i=0; i<n; ++i )  f[i] = cos(1.0*PI*k*i/n + 0.25*PI);

//        jj(f,ldn,0);

//      dif2_walsh_pal(f,ldn);
//      dit2_walsh_pal(f,ldn);
//      dif2_walsh_wal(f,ldn);
//      dit2_walsh_wal(f,ldn);
//      dif2_walsh_wak(f,ldn);
//      dit2_walsh_wak(f,ldn);

//        void nrwt(double a[], ulong ldn, int isign);
        
//        const wavelet_filter &wf = wf_daub12;
//        const wavelet_filter &wf = wf_haar2;
//        const wavelet_filter &wf = wf_test;
//        nrwt(f,ldn,+1);  cout << " nrwt() ";
//        nrwt(f,ldn,-1);  cout << " nrwt() ";
//        wavelet(f,ldn,wf);  cout << " wav() ";
//        inverse_wavelet(f,ldn,wf);  cout << " inv() ";

//        for (long i=0; i<n; ++i )  f[i] = g[i];

//        haar(f,ldn);
//        inplace_haar(f,ldn);
//        for (long i=0; i<n; ++i )  f[i] *= f[i];
//        inplace_inverse_haar(f,ldn);
//        inverse_haar(f,ldn);
//        inverse_int_haar(f,ldn);

//      for (long i=0; i<n; ++i )  f[i] = X01(f[i]);  // for walsh

//      for (long i=0; i<n; ++i )  cout << (int)f[i] << " ";  cout << endl;        

//        // norm:
//        double d = 0.0;
//        for (long i=0; i<n; ++i )  d += f[i]*f[i];
//        cout << sqrt(d) << endl;        

#if  ( 1==UINTIMG )
      for (long i=0; i<n; ++i)  img[k*n+i] = f[i]; 
//      cout << k << ":  seq=" << seqct(f,n) << endl;
#else
        copy(f,img+k*n,n);
#endif
    }

    cout << endl;

    // check norms of rows & cols:
    for (long i=0; i<n; ++i)
    {
#define  SQR(x)  ((x)*(x))
        double u = norm(img+n*i,n);

        double v = 0.0;
        for (long j=0; j<n; ++j)  v += SQR(img[i+j*n]);
        v = sqrt(v);

        cout << " #" << i 
             << ":  n(r)="; cout.width(15); cout << u 
             << "   n(c)=" << v << endl;

    }


    image img1(img,n,k);
    img1.lin_scale(255);
//    img1.lin_scale(10);

    img1.write_pgm_file("tmp.pgm");
    img1.write_ppm_file("tmp.ppm");

    img1.log_scale(255);
    img1.write_pgm_file("tmplog.pgm");
    img1.write_ppm_file("tmplog.ppm");

//    image img2(256,30);
//    for (uint y=0; y<30; y++)
//        for (uint x=0; x<256; ++x)  img2.putpixel(x,y,x);
//    img2.write_pgm_file("tmp.pgm");
//    img2.write_ppm_file("tmp.ppm");

}
