

#include "fxt.h"
#include "fxtdefs.h"  // SUMDIFF, CSQR, CMULT


void
fht_real_complex_fft(double *f, ulong ldn)
//
// isign = +1
//
// ordering on output:
// f[0]     = re[0]
// f[1]     = re[1]
//         ...
// f[n/2-1] = re[n/2-1]
// f[n/2]   = re[n/2](==nyquist freq)
//
// f[n/2+1] = im[n/2-1]  (wrt. complex fft with is=+1)
// f[n/2+2] = im[n/2-2]
//         ...
// f[n-1]   = im[1]
//
// corresponding real and imag parts (with the exception of
// zero and nyquist freq) are found in f[i] and f[n-i]
//
// note that the order of imaginary parts
// is reversed wrt. fft_real_complex_fft()
//
{
    fht(f,ldn);

    const ulong n = (1<<ldn);
    const ulong nh = (n>>1);

    for (ulong i=1,j=n-1; i<nh; i++,j--)  SUMDIFF2_05(f[i], f[j]);
}
// =============== end =========== 


void
fht_real_complex_fft0(double *f, ulong ldn)
//
// version for zero padded data
//
// ordering on output:
// see fht_real_complex_fft()
//
{
    fht0(f,ldn);

    const ulong n = (1<<ldn);
    const ulong nh = (n>>1);
    for (ulong i=1,j=n-1; i<nh; i++,j--)  SUMDIFF2_05(f[i], f[j]);
}
// =============== end =========== 


void
fht_complex_real_fft(double *f, ulong ldn)
//
// isign = +1
//
// ordering on input:
// like the output of fht_real_complex_fft()
//
{
    const ulong n = (1<<ldn);
    const ulong nh = (n>>1);
    for (ulong i=1,j=n-1; i<nh; i++,j--)  SUMDIFF2(f[i],f[j]);

    fht(f,ldn);
}
// =============== end =========== 


void
realisator(double *gr, const double *gi, ulong n, int is)
//
// get (only) the real part of a fft by the code:
// realisator(gr,gi,n, is);
// fht_complex_real_fft(gr, ldn);
//
{
    if ( is>0 )
    {
        for (ulong i=1, j=n-1;  i<j;  ++i, --j)
        {
            double rs = 0.5*(gr[i]+gr[j]);
            double ia = 0.5*(gi[i]-gi[j]);
            gr[i] = rs;
            gr[j] = ia;
        }
    }
    else
    {
        for (ulong i=1, j=n-1;  i<j;  ++i, --j)
        {
            double rs = 0.5*(gr[i]+gr[j]);
            double ia = 0.5*(gi[i]-gi[j]);
            gr[i] = rs;
            gr[j] = -ia;
        }
    }
}
// ===========================


void
imaginator(const double *gr, double *gi, ulong n, int is)
//
// get (only) the imag part of a fft by the code:
// imaginator(gr,gi,n, is);
// fht_complex_real_fft(gi, ldn);
//
{
    realisator(gi, gr, n, -is);
}
// ===========================
