
#include "copy.h"
#include "auxbit.h"
#include "fxt.h"


#define  REAL_COMPLEX_FFT(x, ldn)   fht_real_complex_fft(x, ldn)
#define  REAL_COMPLEX_FFT0(x, ldn)  fht_real_complex_fft0(x, ldn)

#define  COMPLEX_REAL_FFT(x, ldn)   fht_complex_real_fft(x, ldn)


void
skip_real_complex_fft(double *f, ulong n, ulong d, double *w)
//
// compute real to complex fft of the n elements
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    skip_copy(f, w, n, d);

    ulong ldn = ld(n);
    REAL_COMPLEX_FFT(w, ldn);

    skip_copy_back(w, f, n, d);
}
// =============== end ===========


void
skip_real_complex_fft0(double *f, ulong n, ulong d, double *w)
//
// compute real_fft of the n elements
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    ulong nh = (n>>1);
    skip_copy(f, w, nh, d);
    null(w+nh, nh);

    ulong ldn = ld(n);
    REAL_COMPLEX_FFT0(w, ldn);

    skip_copy_back(w, f, n, d);
}
// =============== end ===========


void
skip_complex_real_fft(double *f, ulong n, ulong d, double *w)
//
// compute complex to real fft of the n elements
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    skip_copy(f, w, n, d);

    ulong ldn = ld(n);
    COMPLEX_REAL_FFT(w, ldn);

    skip_copy_back(w, f, n, d);
}
// =============== end ===========

