
# imported by metagen

@intnames = ();

sub scan_func
{
    @keywords = ('for','while','do','if','else','return');

    print "void\n$mgfuncname($specsig)\n";

    while ( <STDIN> )
    {
        chomp;
        $comment = '';
        $line = $_;
        $cline = $line;

        if ( /^(.*)(\/\/.*)/ )  # split off C++ comments
        {
            $cline = $1;
            $comment = $2;
        }

        $_ = $cline;


        if ( /^ *$/ )           # empty line
        {
            print "//PR(\"$cline$comment\");\n";
            next;
        }

        if ( /^ *\#/ )          # CPP statement
        {
            print "$cline$comment\n";
            next;
        }

        if ( /\{/ )             # brace open
        {
            if ( $debug )  { $class =  ""; }
            print "$cline PR(\"$cline\"); $comment\n";
            next;
        }

        if ( /\}/ )             # brace close
        {
            if ( $debug )  { $class =  ""; }
            print "PR(\"$cline\"); $cline $comment\n";
            if ( $line =~ /^\}/ )
            {
                goto doneOK;
            }
            next;
        }


#        $ptrdecl = 0;
        $tt = $cline;
        while ( $tt =~ /\* *($idpat) *=(.*)$/ ) # type *fi = f + n
        {
            print STDERR "PTR line: line=[[$_]] ident=[$ident]\n";
            $ident = $1;
            $rhs = $2;
            foreach $t (keys %gentype)
            {
                print STDERR "";
                if ( $rhs =~ /\b$t\b/ )
                {
                    print STDERR "PTR $ident <--= $t\n";
                    $base{$ident} = $t;
                    $base{$t} = 0;  # base{generic} = 0;
                }
            }

            $tt = $rhs;
#            $ptrdecl = 1;
        }


        if ( /\[.+\]/ )         # array indices f[k] or fi[k]
        {
            if ( $debug )  { $class = "      // *** ARRAY_line "; }
            print "//$cline$comment$class\n";

            $nline = $cline;
            while ( $nline =~ /^([^\[]*)($idpat)\[([^\]]+)\](.*)$/ ) # f[k]
            {
                $head = $1;
                $ident = $2;
                $idx = $3;
                $tail = $4;

                $bs = 0;
                $bsname = $ident;
                if ( $base{$ident} )
                {
                    $bs = $base{$ident};
                    $bsname = $bs;
                }

#                if ( $debug )  { print STDERR "NLINE==[[$head | $ident($bs)\[$idx\] | $tail]]\n"; }

#                $nline = "$head $ident\#1\" << IDX($ident, $bs, $idx) << \"\#2$tail";
                $nline = "$head $bsname\#1\" << IDX($ident, $bs, $idx) << \"\#2$tail";
            }
            $nline =~ s/\#1/\[/g;
            $nline =~ s/\#2/\]/g;
#        $nline = "cout << \"$nline\" << endl;";
#        print "$nline\n";
            &meta_out("$nline");

            next;
        }

        foreach $t (@keywords)
        {
            if ( $cline =~ /\b$t\b/ )
            {
                if ( $debug )  { $class = "      // key_line"; }
                print "$cline$comment\n";
                goto next_line;
            }
        }


        if ( /(double|float|Complex) *\* *$idpat *=/ ) # double *fi = f + n
        {
            print "$cline$comment\n";
            next;
        }

        if ( /long +($idpat.*)/ || /int +($idpat.*)/ )
        {
            $_ = $1;
            while ( /[, ]*($idpat)(.*)/ )
            {
                push @intnames, ($1);
                $_ = $2;
#                print STDERR "INTNAMES += $1\n";
            }

            print "$cline$comment\n";
            next;
        }

        foreach $t ( @intnames )
        {
            if ( $cline =~ /$t .*=/ )
            {
                print "$cline$comment\n";
                goto next_line;
            }
        }

        {
            if ( $debug )  { $class =  "      // ???_line"; }
            print "$cline PR(\"$cline\"); $comment\n";
            next;
        }

      next_line:;
    }

    die "scan_func didn't find end of function";

doneOK: return 0;
}

##########################

1; # perl stupidiy

##########################
