
#include "copy.h"
#include "fxtdefs.h"
#include "complextype.h"


void
slow_convolution(const Complex *w , Complex *f, ulong nu)
// _cyclic_ convolution
// (use zero padded data for usual co.)
// result in f
{
    long n = (long)nu;
    long k2;
    long k,tau;

    Complex *r = new Complex[n];

    for (tau=0; tau<n; ++tau)
    {
	Complex s = 0.0;
	for (k=0; k<n; ++k)
	{
             k2 = tau-k;
             if (k2<0)  k2+=n;
	     s += f[k] * w[k2];
	}

        r[tau] = s;
    }

    copy(r, f, n);
    delete [] r;
}
// ============== end ================



void
slow_complex_convolution(const double *wr, const double *wi,
                         double *fr, double *fi, ulong nu)
// _cyclic_ convolution
// (use zero padded data for usual co.)
// result in fr,fi
{
    long n = (long)nu;
    long k2;
    long k,tau;

    double *rr = new double[2*n];
    double *ri = rr + n;

    for (tau=0; tau<n; ++tau)
    {
	double sr = 0.0, si = 0.0;
	for (k=0; k<n; ++k)
	{
             k2 = tau-k;

             if (k2<0)  k2+=n;

	     double ar = fr[k];
	     double ai = fi[k];

	     CMULT(wr[k2],wi[k2],ar,ai);

	     sr += ar;
             si += ai;
	}

        rr[tau] = sr;
        ri[tau] = si;
    }

    copy(rr, fr, n);
    copy(ri, fi, n);

    delete [] rr;
}
// ============== end ================


void
slow_complex_auto_convolution(double *fr, double *fi, ulong nu)
// _cyclic_ self-convolution
// (use zero padded data for usual co.)
{
    slow_complex_convolution(fr, fi, fr, fi, nu);
}
// ============== end ================

void
slow_auto_convolution(Complex *f, ulong nu)
// _cyclic_ self-convolution
// (use zero padded data for usual co.)
{
    slow_convolution(f, f, nu);
}
// ============== end ================
