
#include <math.h>

#include "copy.h"
#include "sincos.h"
#include "fxtdefs.h"
#include "complextype.h"


void
slow_fract_ft(double *fr, double *fi, ulong n, double v)
//
// (slow) fractional fourier transform
// (for v=+-1 this is the usual fourier transform)
//
{
    double *resr = new double[2*n];
    double *resi = resr + n;

    const double ph0 = v*2.0*M_PI/n;

    for (ulong w=0; w<n; ++w)
    {
        double sr=0.0, si=0.0;
        for (ulong k=0; k<n; ++k)
	{
            double c,s;
            sincos(ph0*k*w, &s, &c);

            double r,i;
            CMULT6(c, s, fr[k], fi[k], r, i);

            sr += r;
            si += i;
	}

        resr[w] = sr;
        resi[w] = si;
    }

    copy(resr, fr, n);
    copy(resi, fi, n);

    delete [] resr;
}
// ================== end ====================


void
slow_fract_ft(Complex *f, ulong n, double v)
//
// (slow) fractional fourier transform
// (for v=+-1 this is the usual fourier transform)
//
{
    Complex *res = new Complex[n];

    const double ph0 = v*2.0*M_PI/n;

    for (ulong w=0; w<n; ++w)
    {
        Complex sum = 0.0;
        for (ulong k=0; k<n; ++k)
	{
            double c,s;
            sincos(ph0*k*w, &s, &c);
            sum += f[k] * Complex(c,s);
	}

        res[w] = sum;
    }

    copy(res, f, n);    

    delete [] res;
}
// ================== end ====================
