
#include "copy.h"


void
slow_twodim_convolution(const double *f, double *g, ulong ru, ulong cu)
//
// _cyclic_ convolution
// result in g
//
{
    long r = (long)ru;
    long c = (long)cu;
    long n = r*c;

    double *res = new double[n];

    for (long rtau=0; rtau<r; ++rtau)
    {
        for (long ctau=0; ctau<c; ++ctau)
        {
            double s=0.0;

            for (long kr=0; kr<r; ++kr)
            {
                long k2r = rtau-kr;
                if ( k2r<0 )  k2r += r;

                for (long kc=0; kc<c; ++kc)
                {
                    long k2c = ctau-kc;
                    if ( k2c<0 )  k2c += c;

                    s += ( f[kr*c+kc] * g[k2r*c+k2c] );
                }
            }
        
            res[rtau*c+ctau] = s;
        }
    }

    copy(res,g,n);

    delete [] res;
}
// ============== end ================

