
#include "revbinpermute.h"
#include "reverse.h" // reverse()


void
walsh_circ(double *f, ulong ldn)
// transform wrt. the basis (sequency at end of lines), '*':=1, ' ':=-1:
// 0: [* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *] ( 0)
// 1: [* * * * * * * *                                 * * * * * * * *] ( 2)
// 2: [* * * *                 * * * * * * * *                 * * * *] ( 4)
// 3: [* * * *         * * * *                 * * * *         * * * *] ( 6)
// 4: [* *         * * * *         * * * *         * * * *         * *] ( 8)
// 5: [* *         * *     * * * *         * * * *     * *         * *] (10)
// 6: [* *     * *         * *     * * * *     * *         * *     * *] (12)
// 7: [* *     * *     * *     * *         * *     * *     * *     * *] (14)
// 8: [*     * *     * *     * *     * *     * *     * *     * *     *] (16)
// 9: [*     * *     *   * *     * *     * *     * *   *     * *     *] (18)
//10: [*     *   * *     * *   *     * *     *   * *     * *   *     *] (20)
//11: [*     *   * *   *     *   * *     * *   *     *   * *   *     *] (22)
//12: [*   *     *   * *   *     *   * *   *     *   * *   *     *   *] (24)
//13: [*   *     *   *   *   * *   *     *   * *   *   *   *     *   *] (26)
//14: [*   *   *   *     *   *   *   * *   *   *   *     *   *   *   *] (28)
//15: [*   *   *   *   *   *   *   *     *   *   *   *   *   *   *   *] (30)
//16: [*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ] (31)
//17: [*   *   *   *     *   *   *   *   *   *   *   * *   *   *   *  ] (29)
//18: [*   *     *   *   *   * *   *   *   *     *   *   *   * *   *  ] (27)
//19: [*   *     *   * *   *     *   *   *   * *   *     *   * *   *  ] (25)
//20: [*     *   * *   *     *   * *   *     *   * *   *     *   * *  ] (23)
//21: [*     *   * *     * *   *     *   * *   *     * *     *   * *  ] (21)
//22: [*     * *     *   * *     * *   *     * *     *   * *     * *  ] (19)
//23: [*     * *     * *     * *     *   * *     * *     * *     * *  ] (17)
//24: [* *     * *     * *     * *     * *     * *     * *     * *    ] (15)
//25: [* *     * *         * *     * *     * *     * * * *     * *    ] (13)
//26: [* *         * *     * * * *     * *         * *     * * * *    ] (11)
//27: [* *         * * * *         * *     * * * *         * * * *    ] ( 9)
//28: [* * * *         * * * *         * * * *         * * * *        ] ( 7)
//29: [* * * *                 * * * *         * * * * * * * *        ] ( 5)
//30: [* * * * * * * *                 * * * * * * * *                ] ( 3)
//31: [* * * * * * * * * * * * * * * *                                ] ( 1)
//
// self-inverse
{
    const ulong n = (1<<ldn);

    for (ulong ldm=1; ldm<=ldn; ++ldm) // dit
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = r+mh;
            double *f2 = f+t2;
            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
            reverse(f2, mh);
        }
    }
    revbin_permute(f,n);
}
// ================= end ==================

//// alternative implementation:
//void
//walsh_circ(double *f, ulong ldn)
//{
//    const ulong n = (1<<ldn);
//
//    for (ulong ldm=1; ldm<=ldn; ++ldm) // dit
//    {
//        const ulong m = (1<<ldm);
//        const ulong mh = (m>>1);
//        for (ulong r=0; r<n; r+=m)
//        {
//            ulong t1 = r;
//            ulong t2 = r+mh;
//            double *f2 = f+t2;
//            reverse(f2, mh);
//            t2 = r + m - 1;
//            for (ulong j=0; j<mh; ++j,++t1,--t2)
//            {
//                double u = f[t1];
//                double v = f[t2];
//                f[t1] = u + v;
//                f[t2] = u - v;
//            }
//        }
//    }
//    revbin_permute(f,n);
//}
//// ================= end ==================
