
#include "revbinpermute.h"
#include "graypermute.h"


// as 'Decimation In Frequency' is 'Decimation In _S_equency' here
// the names could also be dis2_walsh_xyz()


void
dif2_walsh_wak(double *f, ulong ldn)
//
// transform wrt. to walsh-kronecker basis (wak-functions)
// the basis: (sequency at end of lines, '*':=1, ' ':=-1)
// 0: [* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *] ( 0)
// 1: [*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ] (31)
// 2: [* *     * *     * *     * *     * *     * *     * *     * *    ] (15)
// 3: [*     * *     * *     * *     * *     * *     * *     * *     *] (16)
// 4: [* * * *         * * * *         * * * *         * * * *        ] ( 7)
// 5: [*   *     *   * *   *     *   * *   *     *   * *   *     *   *] (24)
// 6: [* *         * * * *         * * * *         * * * *         * *] ( 8)
// 7: [*     *   * *   *     *   * *   *     *   * *   *     *   * *  ] (23)
// 8: [* * * * * * * *                 * * * * * * * *                ] ( 3)
// 9: [*   *   *   *     *   *   *   * *   *   *   *     *   *   *   *] (28)
//10: [* *     * *         * *     * * * *     * *         * *     * *] (12)
//11: [*     * *     *   * *     * *   *     * *     *   * *     * *  ] (19)
//12: [* * * *                 * * * * * * * *                 * * * *] ( 4)
//13: [*   *     *   *   *   * *   *   *   *     *   *   *   * *   *  ] (27)
//14: [* *         * *     * * * *     * *         * *     * * * *    ] (11)
//15: [*     *   * *     * *   *     * *     *   * *     * *   *     *] (20)
//16: [* * * * * * * * * * * * * * * *                                ] ( 1)
//17: [*   *   *   *   *   *   *   *     *   *   *   *   *   *   *   *] (30)
//18: [* *     * *     * *     * *         * *     * *     * *     * *] (14)
//19: [*     * *     * *     * *     *   * *     * *     * *     * *  ] (17)
//20: [* * * *         * * * *                 * * * *         * * * *] ( 6)
//21: [*   *     *   * *   *     *   *   *   * *   *     *   * *   *  ] (25)
//22: [* *         * * * *         * *     * * * *         * * * *    ] ( 9)
//23: [*     *   * *   *     *   * *     * *   *     *   * *   *     *] (22)
//24: [* * * * * * * *                                 * * * * * * * *] ( 2)
//25: [*   *   *   *     *   *   *   *   *   *   *   * *   *   *   *  ] (29)
//26: [* *     * *         * *     * *     * *     * * * *     * *    ] (13)
//27: [*     * *     *   * *     * *     * *     * *   *     * *     *] (18)
//28: [* * * *                 * * * *         * * * * * * * *        ] ( 5)
//29: [*   *     *   *   *   * *   *     *   * *   *   *   *     *   *] (26)
//30: [* *         * *     * * * *         * * * *     * *         * *] (10)
//31: [*     *   * *     * *   *     *   * *   *     * *     *   * *  ] (21)
//
// self-inverse
{
    const ulong n = (1<<ldn);
    for (ulong ldm=ldn; ldm>=1; --ldm)
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = r+mh;
            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
        }
    }
}
// ================= end ==================


void
dif2_walsh_wal(double *f, ulong ldn)
//
// transform wrt. to walsh-kaczmarz basis (wal-functions)
// the basis: (sequency at end of lines, '*':=1, ' ':=-1)
// 0: [* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *] ( 0)
// 1: [* * * * * * * * * * * * * * * *                                ] ( 1)
// 2: [* * * * * * * *                                 * * * * * * * *] ( 2)
// 3: [* * * * * * * *                 * * * * * * * *                ] ( 3)
// 4: [* * * *                 * * * * * * * *                 * * * *] ( 4)
// 5: [* * * *                 * * * *         * * * * * * * *        ] ( 5)
// 6: [* * * *         * * * *                 * * * *         * * * *] ( 6)
// 7: [* * * *         * * * *         * * * *         * * * *        ] ( 7)
// 8: [* *         * * * *         * * * *         * * * *         * *] ( 8)
// 9: [* *         * * * *         * *     * * * *         * * * *    ] ( 9)
//10: [* *         * *     * * * *         * * * *     * *         * *] (10)
//11: [* *         * *     * * * *     * *         * *     * * * *    ] (11)
//12: [* *     * *         * *     * * * *     * *         * *     * *] (12)
//13: [* *     * *         * *     * *     * *     * * * *     * *    ] (13)
//14: [* *     * *     * *     * *         * *     * *     * *     * *] (14)
//15: [* *     * *     * *     * *     * *     * *     * *     * *    ] (15)
//16: [*     * *     * *     * *     * *     * *     * *     * *     *] (16)
//17: [*     * *     * *     * *     *   * *     * *     * *     * *  ] (17)
//18: [*     * *     *   * *     * *     * *     * *   *     * *     *] (18)
//19: [*     * *     *   * *     * *   *     * *     *   * *     * *  ] (19)
//20: [*     *   * *     * *   *     * *     *   * *     * *   *     *] (20)
//21: [*     *   * *     * *   *     *   * *   *     * *     *   * *  ] (21)
//22: [*     *   * *   *     *   * *     * *   *     *   * *   *     *] (22)
//23: [*     *   * *   *     *   * *   *     *   * *   *     *   * *  ] (23)
//24: [*   *     *   * *   *     *   * *   *     *   * *   *     *   *] (24)
//25: [*   *     *   * *   *     *   *   *   * *   *     *   * *   *  ] (25)
//26: [*   *     *   *   *   * *   *     *   * *   *   *   *     *   *] (26)
//27: [*   *     *   *   *   * *   *   *   *     *   *   *   * *   *  ] (27)
//28: [*   *   *   *     *   *   *   * *   *   *   *     *   *   *   *] (28)
//29: [*   *   *   *     *   *   *   *   *   *   *   * *   *   *   *  ] (29)
//30: [*   *   *   *   *   *   *   *     *   *   *   *   *   *   *   *] (30)
//31: [*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ] (31)
//
// the wal functions are sequency- ordered
//
// self-inverse
{
    const ulong n = (1<<ldn);
//    gray_permute(f,n);
//    revbin_permute(f,n);
//    dif2_walsh_wak(f,ldn);

    // this version saves the gray_permute():
    for (ulong ldm=ldn; ldm>=1; --ldm) // dif
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = r+mh;

            // double *f2 = f+t2;
            // reverse(f2, mh); ==
            for (ulong i=r+mh,j=i+mh-1; i<j; ++i,--j)  swap(f[i], f[j]);

            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
        }
    }
    revbin_permute(f,n);
}
// ================= end ==================


void
dif2_walsh_pal(double *f, ulong ldn)
//
// transform wrt. to walsh-paley basis (pal-functions)
// the basis: (sequency at end of lines, '*':=1, ' ':=-1)
// 0: [* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *] ( 0)
// 1: [* * * * * * * * * * * * * * * *                                ] ( 1)
// 2: [* * * * * * * *                 * * * * * * * *                ] ( 3)
// 3: [* * * * * * * *                                 * * * * * * * *] ( 2)
// 4: [* * * *         * * * *         * * * *         * * * *        ] ( 7)
// 5: [* * * *         * * * *                 * * * *         * * * *] ( 6)
// 6: [* * * *                 * * * * * * * *                 * * * *] ( 4)
// 7: [* * * *                 * * * *         * * * * * * * *        ] ( 5)
// 8: [* *     * *     * *     * *     * *     * *     * *     * *    ] (15)
// 9: [* *     * *     * *     * *         * *     * *     * *     * *] (14)
//10: [* *     * *         * *     * * * *     * *         * *     * *] (12)
//11: [* *     * *         * *     * *     * *     * * * *     * *    ] (13)
//12: [* *         * * * *         * * * *         * * * *         * *] ( 8)
//13: [* *         * * * *         * *     * * * *         * * * *    ] ( 9)
//14: [* *         * *     * * * *     * *         * *     * * * *    ] (11)
//15: [* *         * *     * * * *         * * * *     * *         * *] (10)
//16: [*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ] (31)
//17: [*   *   *   *   *   *   *   *     *   *   *   *   *   *   *   *] (30)
//18: [*   *   *   *     *   *   *   * *   *   *   *     *   *   *   *] (28)
//19: [*   *   *   *     *   *   *   *   *   *   *   * *   *   *   *  ] (29)
//20: [*   *     *   * *   *     *   * *   *     *   * *   *     *   *] (24)
//21: [*   *     *   * *   *     *   *   *   * *   *     *   * *   *  ] (25)
//22: [*   *     *   *   *   * *   *   *   *     *   *   *   * *   *  ] (27)
//23: [*   *     *   *   *   * *   *     *   * *   *   *   *     *   *] (26)
//24: [*     * *     * *     * *     * *     * *     * *     * *     *] (16)
//25: [*     * *     * *     * *     *   * *     * *     * *     * *  ] (17)
//26: [*     * *     *   * *     * *   *     * *     *   * *     * *  ] (19)
//27: [*     * *     *   * *     * *     * *     * *   *     * *     *] (18)
//28: [*     *   * *   *     *   * *   *     *   * *   *     *   * *  ] (23)
//29: [*     *   * *   *     *   * *     * *   *     *   * *   *     *] (22)
//30: [*     *   * *     * *   *     * *     *   * *     * *   *     *] (20)
//31: [*     *   * *     * *   *     *   * *   *     * *     *   * *  ] (21)
//
// self-inverse
{
    const ulong n = (1<<ldn);
    revbin_permute(f,n);
    dif2_walsh_wak(f,ldn);
}
// ================= end ==================

