
#include "hfloat.h"


void
elliptic_K(const hfloat &k, hfloat &K, int pq/*=0*/)
// compute K(k) = pi/(2*agm(1,k))
// if pq!=0 then K`(k)=K(sqrt(1-k*k)) is computed
{
    if ( !pq )
    {
        K = k;
    }
    else
    {
        sqr(k,K);
        sub(1,K,K);
        sqrt(K,K);
    }

    agm1(K, K);

    div(K, constant_pi(K.prec()), K);

    K /= 2;
} 
// =================== end ===================
