 
#include <math.h>

#include "hfloat.h"

static int
check_const(hfloat *&h, ulong &myrx, ulong n)
//
// allocate if necessary
// return if computation has to be done
//
{
    if ( !h )  // first time ?
    {
        h = new hfloat(n);
        myrx = hfloat::radix();
        return 1;
    }

    if ( n > (h->size()) )  // need more digits ?
    {
        h->prec(n);
        myrx = hfloat::radix();
        return 1;
    }

    h->prec( n );

    // did a radix change occur ?:
    if ( myrx != (hfloat::radix()) )
    {
        myrx = hfloat::radix();
        return 1;
    }

    return 0;
}
//============== end ==========


const hfloat &
constant_pi(ulong n)
{
    static ulong myrx = 0;
    static hfloat *h = 0;

    if ( check_const(h,myrx,n) )
    {
        pi_4th_order(*h, 0);
    }

    return *h;
}
//============== end ============



const hfloat &
constant_logrx(ulong n)
{
    static ulong myrx = 0;
    static hfloat *h = 0;

    if ( check_const(h,myrx,n) )
    {
        pi_by_log_rx(n, *h);          // pi/log(radix)
        div( constant_pi(n), *h, *h); // log(radix)
    }

    return *h;
}
//============== end ============


const hfloat &
constant_sqrt2(ulong n)
{
    static ulong myrx = 0;
    static hfloat *h = 0;

    if ( check_const(h,myrx,n) )
    {
        isqrt((ulong)2, *h);    // 1/sqrt(2)
        mul(*h, (ulong)2, * h); // sqrt(2)
    }

    return *h;
}
//============= end ===============


const hfloat &
constant_logsqrt2(ulong n)
{
    static ulong myrx = 0;
    static hfloat *h = 0;

    if ( check_const(h,myrx,n) )
    {
        *h = constant_sqrt2(n);   // sqrt(2) = 2^(1/2)
        log_agm(*h, *h);          // log(sqrt(2))
    }

    return *h;
}
//============= end ===============

