/*
	picheck.c
	checks the decimals that come out from pi*.c

*/

#ifdef __WIN32__
   #include <conio.h>
#endif
#include <stdarg.h>

#include "picheck.h"

int bInit = 0;
long ndig = 0;

//
//                finis()
// gives a final ok message. It is called at program exit and is installed by atexit()
//

void finis(void)
{
	#ifdef __WIN32__
	fprintf(stdout, "Press any key to exit...\n");
	getch();
	#endif
   fprintf(stdout, "\npicheck: all %ld digits were ok.\n", ndig);
}

void progexit(int no, char *fmt, ...)
{
	if (*fmt) {
		va_list ap;
		va_start(ap, fmt);
		vprintf(fmt, ap);
		va_end(ap);
	}
	exit(no);
}

//
// 				myprintf()
// works like printf() but checks the output for correct pi decimals
//

int myprintf(char *fmt, ...)
{
   static FILE *fptest = NULL;
	static char piname[] = "\\digits\\pi\\pi_d032k.txt";	 
   static int  ch, cch, i;
   char        buf[100];
   va_list     ap;

   va_start(ap, fmt);
   if (bInit == 0) {
	      ch = !EOF;
   	   fptest = fopen(piname, "r");
      	if (!fptest) progexit(1, "Cannot open %s.\n", piname);
	      fprintf(stdout, "\npicheck: Checking the digits of pi...\n");
			fflush(stdout);
         ndig = 0;
         atexit(finis);
         bInit = 1;
   }
   vsprintf(buf, fmt, ap);
   fprintf(stdout, buf);
   fflush(stdout);
   for (i=0 ; (cch=buf[i]) != '\0'; ++i) 
   {
      if (cch < '0' || cch > '9')
         continue;
		while (1) 
      {
         if (ch == EOF)
            return 4;
	      ch = fgetc(fptest);
         if (ch >= '0' && ch <= '9') break;
         if (ch == EOF) {
            fprintf(stdout, "\nFirst %ld digits were ok.\n", ndig);
            return 4;
         }
      }
		if (ch != cch) 
         progexit(1, "\nDigit %ld wrong: is=%c, should=%c\n",
                     ndig, cch, ch);
      ++ndig;
   }
   return i;
}



