/*
   Calculation of the digits of pi
   by the spigot algorithm of Rabinowitz and Wagon
   98-07-05
*/

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.text.*;
// import java.lang.*;

public class pispigot extends Applet 
	    implements ActionListener {
   int         noofdigits = 1000;  // initial value
   TextArea    taPiDigits;
   int         rows = 18;
   int         cols = 120;
   int         currpos;
   TextField   tfNoOfDigits;
   Button      btnStart;

   
   // initialize the applet
   public void init() {
      add(new Label("The first "));
      tfNoOfDigits = new TextField("  " + String.valueOf(noofdigits), 3);
      add(tfNoOfDigits);
      add(new Label("   decimals of pi"));
      taPiDigits = new TextArea(13, 98);
      btnStart = new Button("Go");
      add(btnStart);
      add(taPiDigits);
      btnStart.addActionListener(this);
   }
 
   // Get user argument
   public void actionPerformed(ActionEvent ev) {
	   if (ev.getSource() == btnStart) {
			noofdigits = Integer.parseInt(tfNoOfDigits.getText().trim());
			if (noofdigits < 4)     noofdigits = 4;
			if (noofdigits > 30000) noofdigits = 30000;
			noofdigits = (noofdigits/4)*4;
			tfNoOfDigits.setText("  " + String.valueOf(noofdigits)+ " ");
			taPiDigits.setText("    pi = ");    
			currpos = 6;
			spigot(noofdigits);
		}
   }
   // perform the spigot algorithm
   void spigot(int noofdigits)
   {
      int a = 10000,b,c,d,e,f[],g,h,i;

      b = c = (noofdigits/4 + 1) * 14;
      f = new int[c];
      d = e = h = i = 0;
      while ((c-=14) > 0) {
         while((g = --b * 2) != 0) {
            d = h*b+a*(i==0 ? a/5 : f[b]);
            h = d/(--g);
            f[b]=d%g;
         }
         i = printChunk(e + d/a);
         e = d % a;
         b = c;
     }
   }

   // print the 4 digits just computed 
   int printChunk(int digits)
   {
      currpos += 6;
	  if (currpos > cols) {
         taPiDigits.append("\n");
         currpos = 6;
      }
      StringBuffer sb= new StringBuffer("  0000");
      int len=String.valueOf(digits).length();
      sb.insert(6-len, digits);
      sb.setLength(6);
      taPiDigits.append(sb.toString());
      return 4;
   }
}

