/*
	echeck.c
	checks the decimals of pi during output to stdout

*/

#include <stdarg.h>
#include "echeck.h"

int  ndig = 0;
static char e[]; 

/*
                finis()
 gives a final ok message. It is called at program exit and is installed by atexit()

*/

void finis(void)
{
   fprintf(stdout, "\ne check: all %d digits were ok.\n", ndig);
}

void progexit(int no, char *fmt, ...)
{
	if (*fmt) {
		va_list ap;
		va_start(ap, fmt);
		vprintf(fmt, ap);
		va_end(ap);
	}
	exit(no);
}

/*
 				myprintf()
 works like printf() but checks the output for correct pi decimals

*/

int myprintf(char *fmt, ...)
{
   int         qch, cch, i;
	static int  k = 0;
   char        buf[100];
   va_list     ap;

   va_start(ap, fmt);
   if (k == 0)  /* install finis() */
      atexit(finis);
   vsprintf(buf, fmt, ap);
   fprintf(stdout, buf); 
   fflush(stdout);
   for (i=0; (qch=buf[i]) != '\0'; ++i) 
   {
      if (qch < '0' || qch > '9') 
         continue;       /* bypass non-digits */
      cch = e[k++]; 
      if (cch == '\0') { /* more output than length of pi[] array */
         fprintf(stdout, "\nFirst %d digits were ok.\n", ndig);
         return strlen(buf);
      }
		if (qch != cch) { /* the output may start with 7128... */
			if (k != 1 || qch != e[k++])
            progexit(1, "\nDigit %d wrong: is=%c, should=%c\n",
                     ndig, cch, qch);
      }
      ++ndig;
   }
   return i;
}

static char e[] = "2"
"7182818284590452353602874713526624977572470936999595749669676277"
"2407663035354759457138217852516642742746639193200305992181741359"
"6629043572900334295260595630738132328627943490763233829880753195"
"2510190115738341879307021540891499348841675092447614606680822648"
"0016847741185374234544243710753907774499206955170276183860626133"
"1384583000752044933826560297606737113200709328709127443747047230"
"6969772093101416928368190255151086574637721112523897844250569536"
"9677078544996996794686445490598793163688923009879312773617821542"
"4999229576351482208269895193668033182528869398496465105820939239"
"8294887933203625094431173012381970684161403970198376793206832823"
"7646480429531180232878250981945581530175671736133206981125099618"
"1881593041690351598888519345807273866738589422879228499892086805"
"8257492796104841984443634632449684875602336248270419786232090021"
"6099023530436994184914631409343173814364054625315209618369088870"
"7016768396424378140592714563549061303107208510383750510115747704"
"1718986106873969655212671546889570350354021234078498193343210681"
"7012100562788023519303322474501585390473041995777709350366041699"
"7329725088687696640355570716226844716256079882651787134195124665"
"2010305921236677194325278675398558944896970964097545918569563802"
"3637016211204774272283648961342251644507818244235294863637214174"
"0238893441247963574370263755294448337998016125492278509257782562"
"0926226483262779333865664816277251640191059004916449982893150566"
"0472580277863186415519565324425869829469593080191529872117255634"
"7546396447910145904090586298496791287406870504895858671747985466"
"7757573205681288459205413340539220001137863009455606881667400169"
"8420558040336379537645203040243225661352783695117788386387443966"
"2532249850654995886234281899707733276171783928034946501434558897"
"0719425863987727547109629537415211151368350627526023264847287039"
"2076431005958411661205452970302364725492966693811513732275364509"
"8889031360205724817658511806303644281231496550704751025446501172"
"7211555194866850800368532281831521960037356252794495158284188294"
"7876108526398139559900673764829224437528718462457803619298197139"
"9147564488262603903381441823262515097482798777996437308997038886"
"7782271383605772978824125611907176639465070633045279546618550966"
"6618566470971134447401607046262156807174818778443714369882185596"
"7095910259686200235371858874856965220005031173439207321139080329"
"3634479727355955277349071783793421637012050054513263835440001863"
"2399149070547977805669785335804896690629511943247309958765523681"
"2859041383241160722602998330535370876138939639177957454016137223"
"6187893652605381558415871869255386061647798340254351284396129460"
"3529133259427949043372990857315802909586313826832914771163963370"
"9240031689458636060645845925126994655724839186564209752685082307"
"5442545993769170419777800853627309417101634349076964237222943523"
"6612557250881477922315197477806056967253801718077636034624592787"
"7846585065605078084421152969752189087401966090665180351650179250"
"4619501366585436632712549639908549144200014574760819302212066024"
"3300964127048943903971771951806990869986066365832322787093765022"
"6014929101151717763594460202324930028040186772391028809786660565"
"1183260043688508817157238669842242201024950551881694803221002515"
"4264946398128736776589276881635983124778865201411741109136011649"
"9507662907794364600585194199856016264790761532103872755712699251"
"8275687989302761761146162549356495903798045838182323368612016243"
"7365698467037858533052758333379399075216606923805336988795651372"
"8559388349989470741618155012539706464817194670834819721448889879"
"0676503795903669672494992545279033729636162658976039498576741397"
"3594410237443297093554779826296145914429364514286171585873397467"
"9189757121195618738578364475844842355558105002561149239151889309"
"9463428413936080383091662818811503715284967059741625628236092168"
"0751501777253874025642534708790891372917228286115159156837252416"
"3077225440633787593105982676094420326192428531701878177296023541"
"3060672136046000389661093647095141417185777014180606443636815464"
"4400533160877831431744408119494229755993140118886833148328027065"
"5383300469329011574414756313999722170380461709289457909627166226"
"0740718749975359212756084414737823303270330168237193648002173285"
"7349359475643341299430248502357322145978432826414216848787216733"
"6701061509424345698440187331281010794512722373788612605816566805"
"3714396127888732527373890392890506865324138062796025930387727697"
"7837928684093253658807339884572187460210053114833513238500478271"
"6937621800490479559795929059165547050577751430817511269898518840"
"8718564026035305583737832422924185625644255022672155980274012617"
"9719280471396006891638286652770097527670697770364392602243728418"
"4088325184877047263844037953016690546593746161932384036389313136"
"4327137688841026811219891275223056256756254701725086349765367288"
"6059667527408686274079128565769963137897530346606166698042182677"
"2456053066077389962421834085988207186468262321508028828635974683"
"9654358856685503773131296587975810501214916207656769950659715344"
"7634703208532156036748286083786568030730626576334697742956346437"
"1670939719306087696349532884683361303882943104080029687386911706"
"6666146800015121143442256023874474325250769387077775193299942137"
"2772112588436087158348356269616619805725266122067975406210620806"
"4988291845439530152998209250300549825704339055357016865312052649"
"5614857249257386206917403695213533732531666345466588597286659451"
"1364413703313936721185695539521084584072443238355860631068069649"
"2485123263269951460359603729725319836842336390463213671011619282"
"1711150282801604488058802382031981493096369596735832742024988245"
"6849412738605664913525267060462344505492275811517093149218795927"
"1800194096886698683703730220047531433818109270803001720593553052"
"0700706072233999463990571311587099635777359027196285061146514837"
"5262095653467132900259943976631145459026858989791158370934193704"
"4115512192011716488056694593813118384376562062784631049034629395"
"0029458341164824114969758326011800731699437393506966295712410273"
"2391387417549230718624545432220395527352952402459038057445028922"
"4688628533654221381572213116328811205214648980518009202471939171"
"0555390113943316681515828843687606961102505171007392762385553386"
"2725535388309606716446623709226468096712540618695021431762116681"
"4009759528149390722260111268115310838731761732323526360583817315"
"1034595736538223534992935822836851007810884634349983518404451704"
"2701893819942434100905753762577675711180900881641833192019626234"
"1628816652137471732547772778348877436651882875215668571950637193"
"6565390389449366421764003121527870222366463635755503565576948886"
"5495002708539236171055021311474137441061344455441921013361729962"
"8569489919336918472947858072915608851039678195942983318648075608"
"3679551496636448965592948187851784038773326247051945050419847742"
"0141839477312028158868457072905440575106012852580565947030468363"
"4459265255213700806875200959345360731622611872817392807462309468"
"5367823106097921599360019946237993434210687813497346959246469752"
"5062469586169091785739765951993929939955675427146549104568607020"
"9901260681870498417807917392407194599632306025470790177452751318"
"6809982284730860766536866855516467702911336827563107223346726113"
"7054907953658345386371962358563126183871567741187385277229225947"
"4337378569553845624680101390572787101651296663676445187246565373"
"0402443684140814488732957847348490003019477888020460324660842875"
"3518483649591950828883232065221281041904480472479492913422849519"
"7002260131043006241071797150279343326340799596053144605323048852"
"8972917659876016667811937932372453857209607582277178483361613582"
"6128962261181294559274627671377944875867536575448614076119311259"
"5851265575973457301533364263076798544338576171533346232527057200"
"5303988289499034259566232975782488735029259166825894456894655992"
"6584547626945287805165017206747854178879822768065366506419109734"
"3452887833862172615626958265447820567298775642632532159429441803"
"9943217000090542650763095588465895171709147607437136893319469090"
"9819045012903070995662266203031826493657336984195557769637876249"
"1885286568660760056602560544571133728684020557441603083705231224"
"2587223438854123179481388550075689381124935386318635287083799845"
"6926199817945233640874295911807474534195514203517261842008455091"
"7084568236820089773945584267921427347756087964427920270831215015"
"6406341341617166448069815483764491573900121217041547872591998943"
"8253649505147713793991472052195290793961376211072384942906163576"
"0459623125350606853765142311534966568371511660422079639446662116"
"3255157729070978473156278277598788136491951257483328793771571459"
"0910648416426783099497236744201758622694021594079244805412553604"
"3131799269673915754241929660731239376354213923061787675395871143"
"6104089409966089471418340698362993675362621545247298464213752891"
"0798843813060955526227208375186298370667872244301957937937860721"
"0725427728907173285487437435578196651171661833088112912024520404"
"8682200072344035025448202834254187884653602591506445271657700044"
"5210977355858976226554849416217149895323834216001140629507184904"
"2778925855274303522139683567901807640604213830730877446017084268"
"8272261177180842664333651780002171903449234264266292261456004337"
"3838683355553434530042648184739892156270860956506293404052649432"
"4426144566592129122564889356965500915430642613425266847259491431"
"4239398845432486327461842846655985332312210466259890141712103446"
"0842716166190012571958707932175696985440133976220967494541854071"
"1844643394699016269835160784892451405894094639526780735457970030"
"7051163682519487701189764002827648414160587206184185297189154019"
"6882532893091496653457535714273184820163846448324990378860690080"
"7270932767312758196656394114896171683298045513972950668760474091"
"5420428429993541025829113502241690769431668574242522509026939034"
"8148564513030699251995904363840284292674125734224477655841778861"
"7173726546208549829449894678735092958165263207225899236876845701"
"7823038096567883112289305809140572610865884845873101658151167533"
"3276748870148291674197015125597825727074064318086014281490241467"
"8047232759768426963393577354293018673943971638861176420900406866"
"3398856841681003872389214483176070116684503887212364367043314091"
"1557332801829779887365909166596124020217785588548761761619893707"
"9438005666336488436508914480557103976521469602766258359905198704"
"2300179465536788567430285974600143785483237068701190078499404930"
"9189191816493272597740300748796814848823429320230121280323274603"
"9221968752834051690697419425761467397811071546418627336909158497"
"3185011183960482533518748438923177292613543024932562896371361977"
"2854566229244616444972845978677115741256703078718851093363444801"
"4967524061853656953207417053348678275482781541556196691105510147"
"2799040386897220465550833170782394808785990501947563108984124144"
"6728218654599715966390156419417518209359326163168883801327587526"
"0146050767609839262572641112013528859131784829947568247256488553"
"3357279772205543568126302535748216585414000805314820697137262149"
"7555760518904816223767904149267426000710459226953148351881374638"
"8710427354476762357793399397063239660496914530327388787455790593"
"4937772320142954803345000695256980935282887783710670585567749481"
"3738586303857628230406940056653405848875270053088324591821834943"
"1804983419963998145877343586311594057044368351528538360944295596"
"4360676090221741896883548131643997437764158365242234642619597390"
"4554506806952328507518687194490647677918867203064186307510535121"
"4985105120731384664871754751838297999018931775155063998101646641"
"4592102406838294603208535554058147159273220677567669213664081505"
"9008069525406106285364082932766219319399338616238360691117677854"
"4823612932685819996523927548842743541440288453645559512473554613"
"9403154952097397051896240157976832639450633230452192645049651735"
"4667756992957189896904709027302885449454166997919929480382549802"
"8594602905276314558031651406622917122342937580614399348491436210"
"7993576737317948964252488813720435579287511385856973381976083524"
"4232404667780209483996399466848337747067254836188482730006483191"
"6382602211055522124673332318446300550448184991699662208774614021"
"6157021029603318588727333298779352570182393861244026868339555870"
"6077581699543984695685406711744449324795195721594196458637361269"
"1552645757478698596424217659289686238350637043393981167139754473"
"6228625506803682664135541448048997721373174119199970017293907303"
"3508690209225191244473932783761563218108428982077069741387070532"
"6611768369864774178718020272941298231088879683188085436732780687"
"9771659111654224453806625861711729498038248879986504061563975629"
"9369628093581897614910171453435566595427570641944088338168411111"
"6620075978724413708233391788611470822865753107853667469501846214"
"0736493917366254937783014074302668422150335117736471853872324040"
"4210379077502660201148149354822289166636407824501668153412135052"
"7857853933260611024980227309363674021351538643169301526746053606"
"4351732154701091440650878823636764236831187390937464232609021646"
"3656275539768340194829327957506243996452725786244003759834220508"
"0893512902312247597064410567836187087717233355546548259890686120"
"1410107222465904008553798235253885171623518256518482203125214950"
"7003783004112162121260527260599443204430562745229161288917668141"
"6063913123597535039032007752958739241247645185080916391145929607"
"1156344204347133544720981178461451077872399140606290228276664309"
"2649005922498102910687594345338583303911787475759770659535709796"
"4001222409219903115822925966791315399156143807012926078019702258"
"9662923368154312499412259460023399472228171056603931877226800493"
"8331489803385489094686851307892920642428191747958661999444111962"
"0873049806438500685262025843284208558233856693664984972081704613"
"5376163584015342840674118587581546514598270228676671855309311923"
"3401912861706133648731831975608125694600894029530944291195902959"
"6856392303768997632746228390073545714459641410822928592223933283"
"6210192822937243590283003884445701383771632056518351970100115722"
"0109569978904849644534346121292249647323561263219511557015658244"
"2766159932646315580667205312759694853805736420838491888709517605"
"2287817339462747644656858900936266123311152910816041524100214195"
"9373497864316615567327027921095935430555797326605546779635520053"
"7830461954063697184291616858273412221714588587081427409024818544"
"6421774876925093328785670674677381226752831653559245204578070541"
"3525769032535227389638474956462559403789249250076243868937764753"
"1010232374673377147458162553069803249903367645543030527456151296"
"1214585944432150749051491453950981001388737926379964873728396416"
"8975551322759620118382486507469854920380976919326064376087432093"
"8560281564284975654930790973385418558351578940981400769189238906"
"3090542534883896831762904120212949167195811935791203162514344096"
"5031328352167280213724159473440954983161383225054867081722214751"
"3842516679044541661730320082033090289548880851679725849581340713"
"2180533988828139346049850532340472595097214331492586604248511405"
"8195797115641914588428330005256847768743059163904943068713431187"
"9618963747550336282093994934369032103197689811205559536946542470"
"4173323895394046035325396758354395350516720261647961347790912327"
"9952649290451511483079233693821660107028726519381438448445326395"
"1739411013115250275046574934306376654186612891526444692622288436"
"6299462732467958736383501937142786471398054038215513463223702071"
"5331348870831741465914924063594930209211220526103123906829413456"
"9678595851839349138234088427431241909915287080433280913299307893"
"6867127413922890033069995875921815297612482409116951587789964090"
"3525773459382482320530555672380950222667904396142318529919891810"
"6555441247720450851021007152235234279253126693010827063394232176"
"2570076323139159349709946933241013908779161651226804414809765618"
"9797350431513960669132583790337486208366954750832803187867077511"
"7752566396347925921973357794955549865521419339817026863998738834"
"7010255262052312317215254062571636771270010760912281528326508984"
"3595689759610383721577268311707345522501941217015413187936518185"
"0202087732690613359218200076232726950328382739124382819817087116"
"8108951187896746707073377869592565542713340052326706040004348843"
"4329027603604980278621607494696549892104744439278719345367017986"
"7392080384563372331198385586263800851634559719444199434462476112"
"3844617615736242015935078520825600604101556889899501732554337298"
"0735616998611019084720966007083202805699170425901038769286583365"
"5772875868425049269037093426202802239986180340021132074219864291"
"7383679176232826444645756330336556777374808644109969141827774253"
"4170109884358531893391759345115740238472929090154685591637926961"
"9684100067659839974497204728788183120023338329803056786548087147"
"6464512824264478216644266616732096012564794514827125671326697067"
"3671446177956437523917429285039870225837340698523091904649672602"
"4341127034561111414983578390179349971379091369670649763712724846"
"6613279908254305449295528594932793818341607827091326680865655921"
"1027337467001325834287152408356615221655749984312362782871066494"
"0156467014194371382386345472960697869333597310953712649941628265"
"6463708490580151538205338326511289504938566468752921135932220265"
"6818564182608275387900024079158926460284908949222999661674377313"
"4777613415096526244833270934389841205692614510885781224913961691"
"2534202918139898683901335795857624435194008943955180554746554000"
"0517662402028259448288338118863817495942848920135200909510078649"
"4186825600927397766758564259837858749777666956335017074857902724"
"8701370264203283965756348010818356182372177082236423186591595883"
"6694873224117265044872683923284530109916775183768315998212632371"
"2385435731268120244517540185213266374053880290124972818089502155"
"3100673598184430429105288459323064725590442355960551978839325930"
"3395729346630551604309237856772292935372084166931345752840118737"
"4685469162064899116472690942898297106560680180580784360046186622"
"3562874591385185904416250663222249561448724413813849763797102676"
"0208455318241119639279410696194654264800067617276181156300636443"
"2111622483737910562361135883633455010228617051789044057041957785"
"9833348463317921904494652923021469259756566389965893747728751393"
"3771055698024557574361905017724662145875923744186575300649980566"
"8837696422982550119506583784312523213530937123524396914966231011"
"0328243570065781487677299160941153954063362752423712935549926713"
"4850315782388995675452879155784204831057493300601979582077395585"
"2280730704895093623555076983788192635714177933875021634439101418"
"7576711938914416277109602859415809719913429313295145924373636456"
"4730350373745385034892861131416380947523017450887848856457412750"
"0335330341613809656004310586054835577394662503323003434158781463"
"4602169235079216111013148948281895391028916816328709309713184139"
"8154276788180676286509780857182621170031400033773015815363341490"
"9323703470363751335453763452105037099545294205523207881744937093"
"7677056009306353645510913481627378204985657055608784211964039972"
"3445564586076895155696868993848964391952252323097033010372772277"
"1087056491296612106149407278244203341405744144645996823696611887"
"8411656290355117839944070961772567164919790168195234523807446299"
"8776648248737533130181427639105192346850819790017965199070504908"
"6523744284165277661142535153866516278131609096480280123449337242"
"7866930894827913465443931965254154829494577875758599482099181824"
"5224493120777682508307682823350015970404191995605097053646964731"
"4244845382588811260275390954885263970865233905294182969180235712"
"0545328231809270356491743371932080628731303589640570873779967845"
"1747405153174013848780828810060463889367116404777559854812639075"
"0474729501260941999037372124620167703051779035295279316876630509"
"9837441859803498821239340919805055103821539827677291373138006715"
"3392401269545863764220650978108529076390797278413017645532475270"
"7378876406936642001219474570235829548136578180986794402022028082"
"2637957006755393575808086318932075864444206644691649334467698180"
"8117165686652133896861735924509208014653125297779661371986959164"
"5186943232424640440167238197802072839441826450218313148336601938"
"4891972317817154372192103946638473715630226701801343515930442853"
"8489418256788707212385205972638592249347636231221881137063075069"
"1826010968906925141714251421815349153212907772374850663548917089"
"2850760234351768218355008829647410655814882049239533702270536705"
"6307503174997881870099892510201780156010422778362836443237297799"
"2993516092588451577205523289697833312642767129109399310377342591"
"0592303277652667641874842441076564447767097790392324958416348527"
"7351719810646738371427429744689923204069325060628344689375430167"
"8781532061600905769340490614617660709438011091544326192900074520"
"9895959201159412324102274845482605404361871836330268992858623582"
"1456438796952102352666733724344230915771832775658002119282703910"
"4239196642691115533359456968578281702032549555252887546446607462"
"0294766116004435551604735044292127916358748473501590215522120388"
"2811680214138658651684645699648100156337412550984797301386562754"
"6016127924635978366148016387160279440548271019629077454362809261"
"2567507181773641749763254436773503632580004042919906963117397787"
"8750815602273688249670776355598692849016287686996280537901818481"
"4881083394690001638079107596074550468891268679281239114888003672"
"0729730801354431325347713094186717178607522981373539126772812593"
"9582205242899913716906856504215750567299912741771492796088315023"
"5869781619089490848771772250386087261838494793975744066491276051"
"8878124233683125467278331513186758915668300679210215947336858591"
"2013953603016781104134444110309033887615204882969091046891676715"
"5537334662254557597520262477124279622598327840583358589767147420"
"5724047439720232895903726148688388003174146490203843590358527993"
"1238710428459816089961019456916469838377182672646852648691729484"
"1415300460400429958503516410189902752936686743183495544745812414"
"0190754681607770977920579383895378192128847409929537040546962226"
"5472788072486855080465710431238548733516530705707845842433355509"
"5822191286279720545546626709913190237031177969089278662311266133"
"7671178512943059323281605826535623848164192144732543731002062738"
"4668123516910163592525882568064389463898808727352844064622081495"
"1386227523993893873490508262547241778170258204412985376049982789"
"9020083498387362992498125742354568439023012261733665820546785671"
"1479730650770354756205674283001874730191973108811575167770050714"
"3201272635460191246080045160810864183553966994693694732227167074"
"8972850464195392966434725254724357659192969949061670189061433616"
"9070561482809803632434541282299682759802266940456421813286245175"
"4965214722162083982459457661334271056495719356443156177450082837"
"6935700995419541839029151033187933907614207467028867968594985439"
"7894573007689398900700739246974618128557646622654129132040522790"
"7121282065377505828004089716346716370902490677473630913690400261"
"5646432159560910851092445162454420141442641660181385990017417408"
"2442453786101584333617772925806111591920084140918881912088582076"
"2701148367176074904698091444305726221110458330078933169819160391"
"7150622792986282709446275915009683226345073725451366858172483498"
"4700808401638682097263713452054398022778663372932908299140106455"
"8976169745597840921140916768402026937022923174333449998690184151"
"0888993165125090001163719114994852024821586396216294981753094623"
"0476048323993793910021425329964762351635690094450860580912024599"
"0461211862331827861446472779552321863591655188305793065770333149"
"8510068357135624341881884405780028844018129031378653794869614630"
"4677269145529536901541670258380324778422724179945136535822609716"
"5258835671213351954683833534980150326935979816746323184762830634"
"0588324731228951257944267639877946713121042763380872695738609314"
"6315391485487925140288850251897880760238389956156848503919958550"
"2925605417676766314535405849629679678134942011600332587443143874"
"6248313850214980401681940795687219268462617287403480967931949965"
"6042991902818105976032632517464050164546062667655290106398687036"
"6826329905057770626639786845358438405767329826816344864670743999"
"0917504018892319267557518354054956017732907127219134577524905771"
"5127733584233140083560809269622988941630472877800547437984985455"
"6287072996840738293721862383176652471609096719200723765889422618"
"6550487552614557855898773008703234726418384831040394818743616224"
"4552861632876285411759464604970277244907992751464457929825498022"
"5860100177243784016772316680200416254724417941554781055417803677"
"3553354467030326469619447560812831933095679685582771932031205941"
"6166939020496653521896728226719726400294933073847175447537619370"
"1788297638248723336181349941454169473654925484063379367436154108"
"1593464960431603544354737728802361047743115330785159902977771499"
"6102746277697596124888794486098633494228528476513102779262797439"
"8195761750559130099337736824051090258375934517001534052226614407"
"7237050890044496613295859536020556034009492820943862994618834790"
"9328941610988565949542131143356088102394237060871080264659132035"
"6012187593379163966643728283675232839168886537375133579485986010"
"7569374889645657187292540448508624449947816273842517229343960137"
"2124062867836366758453319047439547406640152608719409157439552827"
"7390430386877272826206566312938745987531774997379929304329437176"
"3801856280061141619563942414312254397099163565102848315765427037"
"9068371757648702300523881974987466368562926550582228877132217814"
"4048953809968107214301239469353093152405408121570540227441452187"
"6541901428386744260011889041724570537470755550581632831687247110"
"2203537271661123048573404608792725016947010678311789270955272532"
"2212522436167334336638475659094972822180941868407423835156786889"
"3421148203905824224324264643630201441787982022116248471657468291"
"1463154075637702227401358411090760784647800701827663362279781045"
"4633113129404483357013486958516526745951518768003339552241054818"
"1767867772152798270250117195816577603549732923724732067853690257"
"5362339712168843908788792621882023055299371323971943330835362312"
"4887038641619436150652955126733420719850225977140863812201598089"
"4363561808597010080081622557455039101321981979045520049618583777"
"7210480466355338066165170235950971332036315789456444878009456203"
"6978497345990200460688657270186586775784275853064570661712719496"
"7371083950603267501532435909029491516973738110897934782297684100"
"1176579870981857251313722677497066092504818768355160037146386859"
"1891301173680521874326542606370071059536442506276045825233688055"
"2521181566417553430681181548267844169315284408461087588214317641"
"6498356631275187281829486556585242068522218307553061183933269341"
"6445941534265177865339798058082815880630074995289755820468661259"
"0853678738603318442905510689778698417735603118111677563872589911"
"5168032365470029879896289861810145964713079161443695646909095187"
"8857439882173058388498080952307756935885161602771952148899835863"
"2323127308909861560777386006984035267826785387215920936255817889"
"8134162474864564332110431948214212997931881046363995414965394415"
"0138386874838487022468182939186031959866796236348930928308784071"
"2400431022706137591368056518861313458307990705003607588327248867"
"8793240933800718641528533179435350734018911936385467300006604537"
"8378447246928883054697900013124895210044694903205883829492361391"
"9284305249167833012980192255157050378521810552961623637523647962"
"6857516600665393641422730630016486526138918422435017974559936167"
"9406330352211182907159753882183977755281298153857016870220262027"
"4678647916644030729018445497956399844836807851997088201407769199"
"2616749911483298218543827189462821653870648585886462216114103435"
"7034287886297908341887160621443001453327502971510467315602100004"
"3869510583773779766003460887624861640938645252177935289947578496"
"2552439255986205214090523462508478304870464926883132894705538913"
"5729070696759955629858666955972168650605207280134210435576277918"
"4021797626656484580261591407173477009039475168017709900129391137"
"8812485342559493128666534650337288463906499684606447419075243133"
"2390340490819523304438955906054785495462026325667681326243592502"
"0249516275607080900436460421497025691488555265022810327762115842"
"2824332695286291376626754819935461181439133675797001412558701433"
"1943476403572537691438889968308826284461642557503400142898255762"
"0386364384137906519612917777354183694676232982904981261717676191"
"5542925704384322399184822617443504701991712582146876831726460789"
"5969056998135326443597396517347331948479875806413792688541355252"
"3275720457329477215706850016950046959758389373527538622664943456"
"4370716105115216171762375980509005532321548960628177943022686405"
"7955584573060059837648270333985942009858235140017950710456901919"
"1359062304102336798080907240196312675268916362136351032648077232"
"9149508591512658121438233710729491480884723552863941959934556841"
"5634457795172703337423812990326019816057197118395066275822032183"
"7136059718025940870615534713104482272716848395524105913605919812"
"4449784581108545112316681735348382537248253476367775817128672058"
"6514828531727356906983993511076343209131978031403165889737962830"
"1178409806410175016511072932907832177487566289310650383806093372"
"8413992267333847782033020207005171889417064651462383667206327426"
"4433661217401176691491923557090564480301634229430183765526310845"
"0172510307540942604409687066288066265900569082451407632599158164"
"4993614551724520570204430937223055502172222997062097492686097627"
"8740962644877205604307863480888570914346479324153621430319996569"
"5610753570417207285334250171325558818113295504095217830139465216"
"4365942629607685705856985071571513172629289600725876015648405560"
"8861316541183595862871066549628259953512719324463579104655438916"
"5150954187306071015034430609582302257455974944275067630926322529"
"9663382193952029279179732470945596910164029836830804263099104815"
"6750362350965492430258957527352141244514954246297225851012070780"
"2110188106722347972579330653187713438466713807546383471635428854"
"9576109428418986017946587214444951988015508040425064521914849899"
"2040000731067236994465524602090876788230006433772565738501096989"
"9058191290957079866699453765080407917852438222041070599278889267"
"7457520842875263779867303605612307107239225815047813791727312612"
"3487833403447383357360197323594660427370463520132718259241090604"
"0097638585857716958419563109577748529579836844756803121874818202"
"8339418870763117316152898117564297113341814972180780404650776572"
"0445708285941747511492617936737999922018178939943333773114691197"
"0737861041963986422166045588965683206701337505745038872111332436"
"7398402841886391476334916951140325834758415141703256901617849314"
"5570690416985805021779849763701475891481054320585491410066220172"
"1719726878930012101267481270235940855162601689425111458499658315"
"5896604600915257978816703846259053832569205204257913789488275796"
"0327887753546686144182682779765125895356376148599448504970663840"
"6266121957141911063246061774180577212381659872472432252969098533"
"6284407990300075945462815492355060864815579289619696170607152015"
"8982529977280352000261088881417650663621690592802151642919848407"
"7446143617891415191517976537848282687018750030264867608433204658"
"5254705558824102546548060404373727718347690147206642344343742555"
"1412917850303247126341807652518780292553477400110485399696054992"
"6508093910691337614841834884596365621526610332239417467064368340"
"5047499433398022856103130830384845712947673898562939376419144070"
"3650754462206118649912724964379987580653785020375318997261801440"
"4667793050140301580709266213229273649718653952866567538572115133"
"6061144572228008511837578992195430634136923022931397511437024048"
"3022735762903991179449924848091507100244407848286659857940652553"
"9141041497342780203520135419925977628178182825372022920108186449"
"4483492554217939827232793570958287485971267807831342861807504971"
"7574737373029628047737690893255891459814172485265829951088223005"
"5223242218586191394795184220131553319634363922684259164168669438"
"1225371359607100317436519590277125716045884860448206744109352153"
"2790681603205421596795906641112018761853125671015021223940128566"
"8608469435937408158536481912528004920724042172170913983123118054"
"0432770158356295136562746102488277064888650377651756788068724988"
"6165709484666577067457700020714433252555573655708315032001908299"
"2096545498737419756608619533492312940263904930982014700371161829"
"4859399311999550704553811967112893677352499581820117747997886363"
"9328640580781081865733766815789382765645064291739668557955505318"
"8715314552353070355994740186225988149854660737787698781542360397"
"0809774123615182459640268699796095645238285842359535646151854481"
"6579996646064826139661872030483911956025038111155093842020989459"
"1555760083897989949964566262540514195610780090298667014635238532"
"0660325744668202594306188017730911092127411382691487843556793525"
"7280887554316469307723536376822603608017404066099715117688043492"
"7489197133087822951123746632635635328517394189466510943745768270"
"7822099284680346841574431277398110441867620329544754680775111266"
"6368547994446093480999295187566649990226168601967205374914995122"
"6823637895865245462813439289338365156536992413109638102559114643"
"9238052139078628935616609988364791756331767258565235910695203268"
"9599005488475342416058668982006748316317428632911963339913270908"
"6065074595260357157323069712106423424081597068328707624437165532"
"7502287978025986909811112265588881515208374824500344630465059845"
"6969027616695827898291361353530629133142788188824934213644241783"
"3519319786543940201465328083410341785272489879050919932369270996"
"5671335077119058999459519239906151561654803001453592125506964053"
"4526382345215599921057819137103018897920640888397476766714472731"
"4254467923500524618849237455307575734902707342496298879996942094"
"5959610087025013294533253580456892857072412079659198092255505600"
"6197128354127020207258399417117552092082015109650952668511389757"
"7150810849443508285458749912943857563115668324566827992991861539"
"009255871716840495663991959154034218364537212023678608655364745";
