/*
	picheck.c
	checks the decimals of pi during output to stdout

*/

#include <stdarg.h>
#include "picheck.h"

int  ndig = 0;
char pi[];

/*
                finis()
 gives a final ok message. It is called at program exit and is installed by atexit()

*/

void finis(void)
{
   fprintf(stdout, "\npicheck: all %d digits were ok.\n", ndig);
}

void progexit(int no, char *fmt, ...)
{
	if (*fmt) {
		va_list ap;
		va_start(ap, fmt);
		vprintf(fmt, ap);
		va_end(ap);
	}
	exit(no);
}

/*
 				myprintf()
 works like printf() but catches and checks the output for correct pi decimals

*/

int myprintf(char *fmt, ...)
{
   int         qch, cch, i;
	static int  k = 0;     
   char        buf[100];
   va_list     ap;

   va_start(ap, fmt);
   if (k == 0)  /* install finis() */
      atexit(finis);
   vsprintf(buf, fmt, ap);
   fprintf(stdout, buf); 
   fflush(stdout);
   for (i=0; (qch=buf[i]) != '\0'; ++i) 
   {
      if (qch < '0' || qch > '9') 
         continue;       /* bypass non-digits */
      cch = pi[k++]; 
      if (cch == '\0') { /* more output than length of pi[] array */
         fprintf(stdout, "\nFirst %d digits were ok.\n", ndig);
         return strlen(buf);
      }
		if (qch != cch) { /* the output may start with 14159... */
			if (k != 1 || qch != pi[k++])
            progexit(1, "\nDigit %d wrong: is=%c, should=%c\n",
                     ndig, cch, qch);
      }
      ++ndig;
   }
   return i;
}

char pi[] = "3"
"1415926535897932384626433832795028841971693993751058209749445923"
"0781640628620899862803482534211706798214808651328230664709384460"
"9550582231725359408128481117450284102701938521105559644622948954"
"9303819644288109756659334461284756482337867831652712019091456485"
"6692346034861045432664821339360726024914127372458700660631558817"
"4881520920962829254091715364367892590360011330530548820466521384"
"1469519415116094330572703657595919530921861173819326117931051185"
"4807446237996274956735188575272489122793818301194912983367336244"
"0656643086021394946395224737190702179860943702770539217176293176"
"7523846748184676694051320005681271452635608277857713427577896091"
"7363717872146844090122495343014654958537105079227968925892354201"
"9956112129021960864034418159813629774771309960518707211349999998"
"3729780499510597317328160963185950244594553469083026425223082533"
"4468503526193118817101000313783875288658753320838142061717766914"
"7303598253490428755468731159562863882353787593751957781857780532"
"1712268066130019278766111959092164201989380952572010654858632788"
"6593615338182796823030195203530185296899577362259941389124972177"
"5283479131515574857242454150695950829533116861727855889075098381"
"7546374649393192550604009277016711390098488240128583616035637076"
"6010471018194295559619894676783744944825537977472684710404753464"
"6208046684259069491293313677028989152104752162056966024058038150"
"1935112533824300355876402474964732639141992726042699227967823547"
"8163600934172164121992458631503028618297455570674983850549458858"
"6926995690927210797509302955321165344987202755960236480665499119"
"8818347977535663698074265425278625518184175746728909777727938000"
"8164706001614524919217321721477235014144197356854816136115735255"
"2133475741849468438523323907394143334547762416862518983569485562"
"0992192221842725502542568876717904946016534668049886272327917860"
"8578438382796797668145410095388378636095068006422512520511739298"
"4896084128488626945604241965285022210661186306744278622039194945"
"0471237137869609563643719172874677646575739624138908658326459958"
"1339047802759009946576407895126946839835259570982582262052248940"
"7726719478268482601476990902640136394437455305068203496252451749"
"3996514314298091906592509372216964615157098583874105978859597729"
"7549893016175392846813826868386894277415599185592524595395943104"
"9972524680845987273644695848653836736222626099124608051243884390"
"4512441365497627807977156914359977001296160894416948685558484063"
"5342207222582848864815845602850601684273945226746767889525213852"
"2549954666727823986456596116354886230577456498035593634568174324"
"1125150760694794510965960940252288797108931456691368672287489405"
"6010150330861792868092087476091782493858900971490967598526136554"
"9781893129784821682998948722658804857564014270477555132379641451"
"5237462343645428584447952658678210511413547357395231134271661021"
"3596953623144295248493718711014576540359027993440374200731057853"
"9062198387447808478489683321445713868751943506430218453191048481"
"0053706146806749192781911979399520614196634287544406437451237181"
"9217999839101591956181467514269123974894090718649423196156794520"
"8095146550225231603881930142093762137855956638937787083039069792"
"0773467221825625996615014215030680384477345492026054146659252014"
"9744285073251866600213243408819071048633173464965145390579626856"
"1005508106658796998163574736384052571459102897064140110971206280"
"4390397595156771577004203378699360072305587631763594218731251471"
"2053292819182618612586732157919841484882916447060957527069572209"
"1756711672291098169091528017350671274858322287183520935396572512"
"1083579151369882091444210067510334671103141267111369908658516398"
"3150197016515116851714376576183515565088490998985998238734552833"
"1635507647918535893226185489632132933089857064204675259070915481"
"4165498594616371802709819943099244889575712828905923233260972997"
"1208443357326548938239119325974636673058360414281388303203824903"
"7589852437441702913276561809377344403070746921120191302033038019"
"7621101100449293215160842444859637669838952286847831235526582131"
"4495768572624334418930396864262434107732269780280731891544110104"
"4682325271620105265227211166039666557309254711055785376346682065"
"3109896526918620564769312570586356620185581007293606598764861179"
"1045334885034611365768675324944166803962657978771855608455296541"
"2665408530614344431858676975145661406800700237877659134401712749"
"4704205622305389945613140711270004078547332699390814546646458807"
"9727082668306343285878569830523580893306575740679545716377525420"
"2114955761581400250126228594130216471550979259230990796547376125"
"5176567513575178296664547791745011299614890304639947132962107340"
"4375189573596145890193897131117904297828564750320319869151402870"
"8085990480109412147221317947647772622414254854540332157185306142"
"2881375850430633217518297986622371721591607716692547487389866549"
"4945011465406284336639379003976926567214638530673609657120918076"
"3832716641627488880078692560290228472104031721186082041900042296"
"6171196377921337575114959501566049631862947265473642523081770367"
"5159067350235072835405670403867435136222247715891504953098444893"
"3309634087807693259939780541934144737744184263129860809988868741"
"3260472156951623965864573021631598193195167353812974167729478672"
"4229246543668009806769282382806899640048243540370141631496589794"
"0924323789690706977942236250822168895738379862300159377647165122"
"8935786015881617557829735233446042815126272037343146531977774160"
"3199066554187639792933441952154134189948544473456738316249934191"
"3181480927777103863877343177207545654532207770921201905166096280"
"4909263601975988281613323166636528619326686336062735676303544776"
"2803504507772355471058595487027908143562401451718062464362679456"
"1275318134078330336254232783944975382437205835311477119926063813"
"3467768796959703098339130771098704085913374641442822772634659470"
"4745878477872019277152807317679077071572134447306057007334924369"
"3113835049316312840425121925651798069411352801314701304781643788"
"5185290928545201165839341965621349143415956258658655705526904965"
"2098580338507224264829397285847831630577775606888764462482468579"
"2603953527734803048029005876075825104747091643961362676044925627"
"4204208320856611906254543372131535958450687724602901618766795240"
"6163425225771954291629919306455377991403734043287526288896399587"
"9475729174642635745525407909145135711136941091193932519107602082"
"5202618798531887705842972591677813149699009019211697173727847684"
"7268608490033770242429165130050051683233643503895170298939223345"
"1722013812806965011784408745196012122859937162313017114448464090"
"3890644954440061986907548516026327505298349187407866808818338510"
"2283345085048608250393021332197155184306354550076682829493041377"
"6552793975175461395398468339363830474611996653858153842056853386"
"2186725233402830871123282789212507712629463229563989898935821167"
"4562701021835646220134967151881909730381198004973407239610368540"
"6643193950979019069963955245300545058068550195673022921913933918"
"5680344903982059551002263535361920419947455385938102343955449597"
"7837790237421617271117236434354394782218185286240851400666044332"
"5888569867054315470696574745855033232334210730154594051655379068"
"6627333799585115625784322988273723198987571415957811196358330059"
"4087306812160287649628674460477464915995054973742562690104903778"
"1986835938146574126804925648798556145372347867330390468838343634"
"6553794986419270563872931748723320837601123029911367938627089438"
"7993620162951541337142489283072201269014754668476535761647737946"
"7520049075715552781965362132392640616013635815590742202020318727"
"7605277219005561484255518792530343513984425322341576233610642506"
"3904975008656271095359194658975141310348227693062474353632569160"
"7815478181152843667957061108615331504452127473924544945423682886"
"0613408414863776700961207151249140430272538607648236341433462351"
"8975766452164137679690314950191085759844239198629164219399490723"
"6234646844117394032659184044378051333894525742399508296591228508"
"5558215725031071257012668302402929525220118726767562204154205161"
"8416348475651699981161410100299607838690929160302884002691041407"
"9288621507842451670908700069928212066041837180653556725253256753"
"2861291042487761825829765157959847035622262934860034158722980534"
"9896502262917487882027342092222453398562647669149055628425039127"
"5771028402799806636582548892648802545661017296702664076559042909"
"9456815065265305371829412703369313785178609040708667114965583434"
"3476933857817113864558736781230145876871266034891390956200993936"
"1031029161615288138437909904231747336394804575931493140529763475"
"7481193567091101377517210080315590248530906692037671922033229094"
"3346768514221447737939375170344366199104033751117354719185504644"
"9026365512816228824462575916333039107225383742182140883508657391"
"7715096828874782656995995744906617583441375223970968340800535598"
"4917541738188399944697486762655165827658483588453142775687900290"
"9517028352971634456212964043523117600665101241200659755851276178"
"5838292041974844236080071930457618932349229279650198751872127267"
"5079812554709589045563579212210333466974992356302549478024901141"
"9521238281530911407907386025152274299581807247162591668545133312"
"3948049470791191532673430282441860414263639548000448002670496248"
"2017928964766975831832713142517029692348896276684403232609275249"
"6035799646925650493681836090032380929345958897069536534940603402"
"1665443755890045632882250545255640564482465151875471196218443965"
"8253375438856909411303150952617937800297412076651479394259029896"
"9594699556576121865619673378623625612521632086286922210327488921"
"8654364802296780705765615144632046927906821207388377814233562823"
"6089632080682224680122482611771858963814091839036736722208883215"
"1375560037279839400415297002878307667094447456013455641725437090"
"6979396122571429894671543578468788614445812314593571984922528471"
"6050492212424701412147805734551050080190869960330276347870810817"
"5450119307141223390866393833952942578690507643100638351983438934"
"1596131854347546495569781038293097164651438407007073604112373599"
"8434522516105070270562352660127648483084076118301305279320542746"
"2865403603674532865105706587488225698157936789766974220575059683"
"4408697350201410206723585020072452256326513410559240190274216248"
"4391403599895353945909440704691209140938700126456001623742880210"
"9276457931065792295524988727584610126483699989225695968815920560"
"0101655256375678566722796619885782794848855834397518744545512965"
"6344348039664205579829368043522027709842942325330225763418070394"
"7699415979159453006975214829336655566156787364005366656416547321"
"7043903521329543529169414599041608753201868379370234888689479151"
"0716378529023452924407736594956305100742108714261349745956151384"
"9871375704710178795731042296906667021449863746459528082436944578"
"9772330048764765241339075920434019634039114732023380715095222010"
"6825634274716460243354400515212669324934196739770415956837535551"
"6673027390074972973635496453328886984406119649616277344951827369"
"5588220757355176651589855190986665393549481068873206859907540792"
"3424023009259007017319603622547564789406475483466477604114632339"
"0565134330684495397907090302346046147096169688688501408347040546"
"0742958699138296682468185710318879065287036650832431974404771855"
"6789348230894310682870272280973624809399627060747264553992539944"
"2808113736943388729406307926159599546262462970706259484556903471"
"1972996409089418059534393251236235508134949004364278527138315912"
"5689892951964272875739469142725343669415323610045373048819855170"
"6594121735246258954873016760029886592578662856124966552353382942"
"8785425340483083307016537228563559152534784459818313411290019992"
"0598135220511733658564078264849427644113763938669248031183644536"
"9858917544264739988228462184490087776977631279572267265556259628"
"2542765318300134070922334365779160128093179401718598599933849235"
"4956400570995585611349802524990669842330173503580440811685526531"
"1709957089942732870925848789443646005041089226691783525870785951"
"2983441729535195378855345737426085902908176515578039059464087350"
"6123226112009373108048548526357228257682034160504846627750450031"
"2620080079980492548534694146977516493270950493463938243222718851"
"5974054702148289711177792376122578873477188196825462981268685817"
"0507402725502633290449762778944236216741191862694396506715157795"
"8675648239939176042601763387045499017614364120469218237076488783"
"4196896861181558158736062938603810171215855272668300823834046564"
"7588040513808016336388742163714064354955618689641122821407533026"
"5510042410489678352858829024367090488711819090949453314421828766"
"1810310073547705498159680772009474696134360928614849417850171807"
"7930681085469000944589952794243981392135055864221964834915126390"
"1280383200109773868066287792397180146134324457264009737425700735"
"9210031541508936793008169980536520276007277496745840028362405346"
"0372634165542590276018348403068113818551059797056640075094260878"
"8573579603732451414678670368809880609716425849759513806930944940"
"1515422221943291302173912538355915031003330325111749156969174502"
"7149433151558854039221640972291011290355218157628232831823425483"
"2611191280092825256190205263016391147724733148573910777587442538"
"7611746578671169414776421441111263583553871361011023267987756410"
"2468240322648346417663698066378576813492045302240819727856471983"
"9630878154322116691224641591177673225326433568614618654522268126"
"8872684459684424161078540167681420808850280054143613146230821025"
"9417375623899420757136275167457318918945628352570441335437585753"
"4269869947254703165661399199968262824727064133622217892390317608"
"5428943733935618891651250424404008952719837873864805847268954624"
"3882343751788520143956005710481194988423906061369573423155907967"
"0346149143447886360410318235073650277859089757827273130504889398"
"9009923913503373250855982655867089242612429473670193907727130706"
"8691709264625484232407485503660801360466895118400936686095463250"
"0214585293095000090715105823626729326453738210493872499669933942"
"4685516483261134146110680267446637334375340764294026682973865220"
"9357016263846485285149036293201991996882851718395366913452224447"
"0804592396602817156551565666111359823112250628905854914509715755"
"3900243931535190902107119457300243880176615035270862602537881797"
"5194780610137150044899172100222013350131060163915415895780371177"
"9277522597874289191791552241718958536168059474123419339842021874"
"5649256443462392531953135103311476394911995072858430658361935369"
"3296992898379149419394060857248639688369032655643642166442576079"
"1471086998431573374964883529276932822076294728238153740996154559"
"8798259891093717126218283025848112389011968221429457667580718653"
"8065064870261338928229949725745303328389638184394477077940228435"
"9883410035838542389735424395647555684095224844554139239410001620"
"7693636846776413017819659379971557468541946334893748439129742391"
"4336593604100352343777065888677811394986164787471407932638587386"
"2473288964564359877466763847946650407411182565837887845485814896"
"2961273998413442726086061872455452360643153710112746809778704464"
"0947582803487697589483282412392929605829486191966709189580898332"
"0121031843034012849511620353428014412761728583024355983003204202"
"4512072872535581195840149180969253395075778400067465526031446167"
"0508276827722235341911026341631571474061238504258459884199076112"
"8725805911393568960143166828317632356732541707342081733223046298"
"7992804908514094790368878687894930546955703072619009502076433493"
"3591060245450864536289354568629585313153371838682656178622736371"
"6975774183023986006591481616404944965011732131389574706208847480"
"2365371031150898427992754426853277974311395143574172219759799359"
"6852522857452637962896126915723579866205734083757668738842664059"
"9099350500081337543245463596750484423528487470144354541957625847"
"3564216198134073468541117668831186544893776979566517279662326714"
"8103386439137518659467300244345005449953997423723287124948347060"
"4406347160632583064982979551010954183623503030945309733583446283"
"9476304775645015008507578949548931393944899216125525597701436858"
"9435858775263796255970816776438001254365023714127834679261019955"
"8522471722017772370041780841942394872540680155603599839054898572"
"3546745642390585850216719031395262944554391316631345308939062046"
"7843877850542393905247313620129476918749751910114723152893267725"
"3391814660730008902776896311481090220972452075916729700785058071"
"7186381054967973100167870850694207092232908070383263453452038027"
"8609905569001341371823683709919495164896007550493412678764367463"
"8490206396401976668559233565463913836318574569814719621084108096"
"1884605456039038455343729141446513474940784884423772175154334260"
"3066988317683310011331086904219390310801437843341513709243530136"
"7763108491351615642269847507430329716746964066653152703532546711"
"2667522460551199581831963763707617991919203579582007595605302346"
"2677579439363074630569010801149427141009391369138107258137813578"
"9400559950018354251075111447134261280817432272319742989220353969"
"1000593370490020359577989975912726980925727968658950262066401235"
"6055157473528913765082390259128882549403472546047404184170030832"
"9155378624025101679194480163260544016052779772693478603468863153"
"5728206910896089725208993109800835334162598351931700353380608272"
"1397964347371550155905103826857855165959103164209849506377758374"
"7073537530631763315395824393877176377655922105725825280159380938"
"9640912946823241548621454952150049714459659073137717542254129095"
"8006140863557482455991613160220087761983266793949103069325227403"
"1446053662039550436672652491930938424785011835768836454746467769"
"6256418982273105115225069621082707577131267151516254898686089578"
"9937653762629685142848826467221052271680420121917906941601742024"
"5191424880121287145974957396070771231522432697006975293965374909"
"0215275378771507989871749427670328997515360055409360962108551044"
"7711252813894007943820220289140325613698160695815126499397834831"
"2631986404355720903573873497728482892232562364287635563492516898"
"3716894581262898810363637263612312720052001477050468738685958859"
"6474857287741340876814344925708457433759232729122973418580616095"
"6310615174685251512101565902577944637340657410837353778759856917"
"6018358274316262120060719836509691853310569213220620287024974648"
"0102568044717622698351338608532541291834446998300150562322888172"
"0271105827182211670390000689650092400009025259094331268916280302"
"5766683195144471518528057098745329032310655279487843986589254048"
"6383130024020881841532001972402993261226614819639578581258743095"
"1975815813323926785318830997742749165426697183121180173340117292"
"2247408725224547963467786760402848059758329037524731938983910794"
"6770408597540172590552650560624105722107411819215949753452300437"
"5104945457983423491548702104310682723053731324489484125027746057"
"4279799397529716440694181169419990137131051429160508925106947899"
"4992030141121644436585486260431571261401309410129891518539930443"
"7118320154551801270894955727141045069097579708223495857312871925"
"8334544773352023643110924203484297730629499569376282846064332026"
"8788756712058674089852499591230887735591787879048725527931859089"
"6712164228100801779428421561710380731412253998104207182476651982"
"3522252809019889344968126984533175258435942756187606269877541079"
"4511902163536175727014368787097304066196587939405078213659016891"
"8056343656877341247918600449804272490617295313731567437814332533"
"8615269762778454766729069308155324471919119265344022207194213440"
"1761403274215155694924288972608276701195091661371512155677081511"
"2136719755725871651164381063625245061744523453021671586619150460"
"9482150165620168835968720117382035733935677297068383359779282976"
"1399096897560175617791566311028056218977509926044941149460247876"
"3991412046620041422080619741742900387804616636653716253576720059"
"8645469169116331083725341969893807826505902019310879672362348485"
"8090359124299415322381116149035040993469853445737428721467549784"
"0418951802670829020533165877753901827700391814539886382878386427"
"7763770798620917979487735272527780961435859650351937140909222449"
"2080534934493442748515545479871118817346979104844521508117950188"
"1399347059449563135237033460456234404196899168042913442353249181"
"9650734452543545109567677104395862810834788396809005717208486262"
"3599778175955651812657428980065230125323301499434076104611531540"
"5972267321101746417138495860093257257669645584038595705096506533"
"3792262983839568525005707124056176865800073330033597896450488203"
"0500673982378571519398858479754270318669820133398962735454794920"
"2826807158251456127216280141225173681253644055132438866953501603"
"1691479530846011088242208347295586977795030820004730384836471061"
"0627220638279195052799215204007301636836332774520086720466926104"
"5772625479930468570834719354585610792945425353985236619902040703"
"2234798359426255174428581726589006481608187679519961222005898417"
"9881371100046191216950133496693732876617714201619952734010239335"
"6032979783811446955923955921205402454791241475708321107949925104"
"1865300303776521084270963862184167994353481493105412901996577088"
"8947735120328658828811683469545198261392957983123260822512174993"
"3122730526704199230194951174829894857722348474341287455451973647"
"5677247368073940384086264392034150561192455838800340516291248883"
"0625330998464412050521514942795466537548715926240138345463313622"
"8400317597750325241319649692202539953123028807241133996180223898"
"7509480473198959891881339271813235637834279086689661815451691342"
"5979551204450802958104153859196847619164372226477164210376240341"
"5554433650746323323519259152042132019129321264302686212552203907"
"2609793449479213444049889872103508546753147392893683731411019430"
"8042009513007732057367242564988939045300453855418590976122903934"
"7434417557043430100367019708410021344463792626461284865528477012"
"2103511877403671527817732739596873376200112134573305193084037036"
"7746607234988793063471835826766009894261630875501978523345599313"
"3936420954471123222475728346860690171406559607904814121833311527"
"1383977267652642169908388154151848076270132008594437764759372320"
"8355992666758202692587191063430757772507235108995864815670056401"
"6600674132817612178683025852305360336394814151642383718321020774"
"5566274924408938604128985824901425967267733275579748581787307391"
"2721267308792773639959410041855381836702783509582893103472182231"
"8084725646075686295206142559507606586755305356960972521661444464"
"0142134331912700556147701926583157261021189753983109899867775350"
"3082520905569375309623734300027474434833551920135493344008628438"
"0146317500208617478931961350861606073739994193839290682545931339"
"4054047630240685914207155141691995697956909448310634867034250599"
"8413700864676617126587065841148134752738536287731597529724973046"
"4373816496062733627316161873896754621370832114907427695549187778"
"4017262422979114083284865534390543002524746808210296567613552617"
"8279806648032527320092583427574446963291067883647094632971689226"
"5578490176827155466097404161995817499363239965918896182080863132"
"5383574808320761994143190975352716418849115040510224415755309114"
"6838173890554272266678111220092253858290647073726003132493080735"
"0325744207570323514908204867621218846302360057755052586213451480"
"4880663044885919274050408748331060598259762710565972678961105926"
"8144229518391194855100213864144231343486131169268004810200829504"
"2101235629250149790028092572859466688916244997833476022320355940"
"2979153542150284517090099324178861938178486217172006303551022285"
"0077306135540645493771774814973712416029457138692089045655364133"
"3780286892870160626529289822117310484907603242378969519287584876"
"5987270439361694538052266280952095170503534810817609659478751495"
"1924001213543313147425054340115929235143240758709006914459965626"
"8377938415764578725065051378513244503234346692613986693843644513"
"5024328614528693594855403366161244909002100743861799400887824069"
"3792925675003699392690373060007608944401593948782329641189889569"
"2432111814773542774274683778766689067916631630901547888075566665"
"4302341239685808985641991849255058728228987504334352467075131100"
"6633780246803511125951164611485605247038056096240305740851868436"
"8476066912186918046417914335480814170740664700612776153179676149"
"3720404291871893476769969198074843169473934300439133658032560155"
"6441917566231697599887527117216481156551930489984963725199344672"
"4303115456404746887210490399611241326896554096894694882258814906"
"2345372931744130314061164555260994767496095729585303570235153085"
"4941350651593098859157353187520901838466980164931435971913831464"
"7896424796236709241760625163345934769389778928578593790770093910"
"5363176977488367984651777482849565524282790647403551970938915688"
"7059865352843368090469842939440302919433585356031980677569271561"
"9598521695472765880304715386852747565256299006796643292386821491"
"6484136880907961171959461627525327548617061989353780390640720738"
"1243605437514867726843264321595088919926451598751028334645969347"
"7269180261604323441091054062151650424251308133196933296400541199"
"6790438487966173956306563421127085867652825813917703504464049253"
"8737150831504525289386043763513865596745747149462745770190756372"
"1953997292163134909150768903547567145057302196613340474209836571"
"9225766488504693436831580787988197055117964267075086473063582301"
"1631866579951830859925989253451751942439103124502864485670430329"
"8771564365511840169692811703145495558660095937684582932020215742"
"3240706614674645124205524703321664000764748641994719272153292124"
"7664997557484359126000738787330777331738104309981179304798613234"
"0338028454102991761193078900032020165684003664868569687798495133"
"8862278396138223976375577654211858261968509440957735655619451444"
"9872726707693393987518614030688780669333110182823101034560786990"
"9681238816044314119579621919985199073276512216929103307203577985"
"1274855490530781802549055475219344855934582518455534202625104156"
"2328198856014418709110678693327155921818737971836275954888573623"
"0029069807951046961726396603575304273117504927900331404242558047"
"9503884973554069737445779779471376803534112231317663840959889101"
"3676387267294080131168586567958239949188249951012729872813249696"
"3790314880569955147664950813289148045166950586990578357732626153"
"3595143555838761716610948855456127286771409628031877564767928416"
"2434899164315713431207250537697763673731110438457566630715838754"
"6288229377382476454129256198252329752181709272410535621133237393"
"2363927448020849122838969658989873246273207859611221363446892495"
"5177459737478319429705345931350487834496138952270620746761533483"
"1617695851187349597888261622412534416908381791116014677427343947"
"1313793350305130131727658101049472078125894252897748157004688501"
"9704129472313030205211674228901543423019894321643308479348450142"
"2269895590070787234750984557435100524312206843795257514721281193"
"9756869107674924603178133067269043742396949071010449918131916782"
"7380738287120553720657151581265578395017013612601506582433885918"
"4745435955470389722628131228755629501802418531888408401969079139"
"8992819707041746193758399382377406217886607190458765483986967954"
"5207689280321602646443785851497663691700909534360421305457224709"
"5762317801044885201012979334392514312335329981114033266687939971"
"8133677459938917286158653251411345032263032377134692148227639702"
"5647300757426082482654534671262913503997613179387308280488485225"
"6801179196298033862601809557797574530660685535748233053537070662"
"1133530699216837515689371794312171028180578316962175737098072959"
"8369708325104201985157666372050571134612082646034381930092331468"
"3249902746898558690913245216580375233828141660723801923084907563"
"4561483726360256853029846829901622384705174936396079598546711551"
"2413784569720331424486792470341843416108033751739244639631224015"
"0007101464469257293730005091570500564104987718287210923395878846"
"4256055257402985186739268924830412583715936441353351391983343177"
"8786526380754605004628017053391720096682717498041250843557636708"
"9156621588284342883419793471163826449374144842689246152913130462"
"9432630625589089494404820163577493123006881081227925264635731473"
"7662371427825233457875929590067587183978696688159871244724172628"
"6914863698875690133730854661516524095930501460151829785404930901"
"5377235335974272420792730915242454034656041103784514341015141469"
"1325120462259083347783263329967132375512768208218211799247089612"
"6840215564314045108098670383351876711611729536863106588861390858"
"6578243553795865212193890221644162027388036363892016294959342764"
"6531446718143838139232900820420119172373847216253822197961905135"
"7946748561255473614569719225211256217861209255232786030167106369"
"2845033143264667311941845872806679032484576650128111683661424910"
"2984732249953194059781692807896427816045991436059206724997267971"
"4471097381583869882298806604393976583825653667418097417442571743"
"4914543499921214517993033854230022919430664174713329272976344577"
"0443505424359593000126843375827026919000385623254339507245501267"
"1324714261079190145496515230569980975469074618818199898083285669"
"8107642480368791389839869913791039093644526321520953870429070490"
"3761864593096151305632773302964048600671908207523206915530163798"
"3887356624107253344525088379871273645915195127859299215662871554"
"1655943756847636953900194302619356066675078721772187736277488976"
"0207349586460299703647605906291635244538873092518953961688074916"
"5232210583963098727563698456614944998959015313081354112356658395"
"6577236750049386744331025053627776396397353240488226113975042511"
"9261202874675427597635771195458148704490062385249079230626113737"
"7259438241955964611061098687995625654937816975796335539259804935"
"8732365745944595398286724932075845974466161789805544357893490939"
"5701023673690589201002786982717840429099259907473299389451702192"
"7224508865892210271488697269125992303612712590150276017495699442"
"2636682423726873266693301520248530772265081760613364328720584631"
"1745146925090346557427433614803699578312900688155067541893926563"
"1121687629662093453972322775177725929298029732895981119400247113"
"0638241151498351294027101379357760022712712287227842550617716802"
"8676122761115698226209739383487781739884745656174218030209084174"
"5598173205604571486244520015231539189138322418780866079489916340"
"1662064253745477448557010048881407583022807998913634570828262188"
"5853053450973346868151342492150515545910240085994653167366058415"
"2434852891072834951387562630121778710498806673853772434655225883"
"8924953966899673136344763852996658523974873463146808067985909940"
"6996463126896663407973593435348210733450940952246410712752953318"
"0303341877256014275789781052677499011152537826595438777121666341"
"8622126022828058831265120771066765082588293040049895262095678481"
"5809837415025927928330742827009608557684909613736804067224964932"
"1308823757123905924208165729665213348896070566845305916869173352"
"7777542243389949431417226506514609741229569124796623040377602659"
"5678332364854654207436726800355286692767974730362695238109519122"
"7294619053178460432916594696745235723885781503184447345086399978"
"8784941086391851277363073862537657276074756411338570919646104183"
"8514102635456660797901908869319677927385196238716442859027380520"
"6004989186989135455965751657252176951426628773800295636671832568"
"8460042979038975664121235059295153861978671919691361731871098921"
"0786634315098015685189585200521517909715861350159287463460293752"
"6192334102615904640535536143451203080332877104346580387685970793"
"9475457130209721197132310058236008871044788994751284036617901413"
"3947916666900230012825842223278602836699104981828375927202557544"
"5757466664927809491087135351030294550251013236959878723254491122"
"3981711765661501051671204840481281693688050264662684703731519404"
"5353895414946943964429601027968844909958028511403317069075588602"
"6559686229374919020850736569468972351868533908204870068078492555"
"9556054053666272805267436464950770428540906833923964631409136507"
"2998871904204778452972478727160722210188183234370106257573572106"
"1578262819154903987947758136963262025357918154140663122198757446"
"1776416108329089503714529035585958921231012630651526615354350681"
"9546669975152400912522537364178996562895227182531205530790740447"
"8531736738910189996946548776187498808215620390134176806697075573"
"7858387800053082560254373849546560232635319697532074700031987506"
"8575809716962777856654153275054869697957782703820242403482343905"
"5866557777485647193028710379483899227657905078433243163541685221"
"4060506613405698793729935538484864857207775576229721542039068358"
"5612941218492520193789965579764045173403247619199208303456800799"
"2497201591949586375849012215461205574514235130901746256970538836"
"7668790879490369207214912277580461493968975050204378482424226647"
"7890764604369252215461090292638276362357292340103746289827909062"
"6204133912544640566756301315678872512192780395496963395605744698"
"0094764133835755009760483344563417740146436894150156308313851239"
"3910512331982235030234760960974521499826332166085281338293304390"
"1241018160402279356698648363797377359793083424444671918024143693"
"7162591090520357049643700345826020365837685042291847576580546365"
"3458254751539195159692097073168874716537319801669266653211414821"
"1600583468211653807143327455330519590567718607105664455981806831"
"7857850588608336089555367161821347532824737692785457439193598971"
"1599373678153385201998709876131648323799000488398272496264830236"
"9518853581748948027277556930362696816505992645595137680150816389"
"2831282781522211516710824610511222699969769649752747308377582171"
"8297074688754535264161428095098327275543112447326827745701823414"
"2152319149433896081919763394302956854613060755941043174222960013"
"5625853371410586078491840972308601093317529864744271626640483751"
"2501138178685915621801088983768501689483214213987771965781449226"
"5024052963542205324755329798127650642731989763363143122349221977"
"3573362980838241846280205922993813778351039668847917415517252747"
"8533444905343816430643279580063777516857643062710036481378072451"
"4243786133934713902628947790080832953465303587306031620050994281"
"7877420075341348146050019249953611349914452679965612391498505549"
"837856381604858822351240832332912734185682901844694274643956816";
